/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.olap;

import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapHierarchy;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapLevel;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.rules.AbstractRule;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.core.model.NavigationHelper;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.BaseHierarchy;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.BaseLevel;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXLevels;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXMembers;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXNumericConstant;
import com.ibm.cognos.aurora.qls.query.planner.rules.olap.OLAPQueryRule;
import com.ibm.cognos.aurora.qls.query.queryspec.SelectionActionNodes;

@Deprecated
public class ConvertNodeSelectionsToMDXLevels
extends OLAPQueryRule {
    private static final String SUPPRESS_MEMBERS_PROJECTION = "suppressMembersProjection";

    public ConvertNodeSelectionsToMDXLevels() {
        this.mName = "Convert nodes selection to a MDX Levels.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{22};
        this.mMode = AbstractRule.Mode.TOP_DOWN;
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!ConvertNodeSelectionsToMDXLevels.hasOLAPDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with an OLAP data source.", trace);
            return false;
        }
        this.traceNodeCondition(true, "SelectionActionNodes needs to be converted to a MDX Levels.", trace);
        return true;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        INode[] nodes;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SelectionActionNodes selectNodes = (SelectionActionNodes)node;
        for (INode aNode : nodes = selectNodes.getNodes()) {
            IDataItem dataItem;
            if (aNode.isAttribute()) {
                if ("cIdentifier".equals(aNode.getConcept().getName())) {
                    dataItem = aNode.getDataItem();
                } else {
                    INode category = NavigationHelper.getCategoryFromAttribute((INode)aNode);
                    dataItem = NavigationHelper.getIdentifierAttributeFromCategory((INode)category).getDataItem();
                }
            } else {
                dataItem = NavigationHelper.getIdentifierAttributeFromCategory((INode)aNode).getDataItem();
            }
            IOlapLevel levelMetadata = (IOlapLevel)dataItem.getPhysicalMetadata();
            IOlapHierarchy hierarchyMetadata = levelMetadata.getHierarchy();
            if (hierarchyMetadata.isParentChild()) {
                MDXMembers mdxMembersNode = (MDXMembers)nodeFactory.createNode(2006, node);
                MDXLevels mdxLevelsNode = (MDXLevels)nodeFactory.createNode(2009, (IXQEQueryNode)mdxMembersNode);
                mdxMembersNode.addChild(mdxLevelsNode);
                BaseHierarchy baseHierNode = (BaseHierarchy)nodeFactory.createNode(2012, (IXQEQueryNode)mdxLevelsNode);
                baseHierNode.setHierarchyUniqueName(hierarchyMetadata.getUniqueName());
                baseHierNode.setPropertyValue(SUPPRESS_MEMBERS_PROJECTION, Boolean.TRUE);
                MDXNumericConstant depthConstNode = (MDXNumericConstant)nodeFactory.createNode(2015, (IXQEQueryNode)mdxLevelsNode);
                depthConstNode.setConstantValue(levelMetadata.getLevelNumber());
                mdxLevelsNode.addChild(baseHierNode);
                mdxLevelsNode.addChild(depthConstNode);
                node.addChild((IXQEQueryNode)mdxMembersNode);
                continue;
            }
            BaseLevel baseLevelNode = (BaseLevel)nodeFactory.createNode(2008, node);
            String lun = levelMetadata.getUniqueName();
            baseLevelNode.setLevelUniqueName(lun);
            node.addChild((IXQEQueryNode)baseLevelNode);
        }
        node.extract();
    }
}

