/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.olap;

import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXComparisonOperator;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXNumericOperator;
import com.ibm.cognos.aurora.qls.query.planner.rules.olap.OLAPQueryRule;
import com.ibm.cognos.aurora.qls.query.queryspec.OperatorNode;

public class ConvertOperatorToMDXOperator
extends OLAPQueryRule {
    public ConvertOperatorToMDXOperator() {
        this.mName = "Convert a query operator to an MDX operator.";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{12};
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!ConvertOperatorToMDXOperator.hasOLAPDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with an OLAP data source.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The operator needs to be converted to an MDX operator.", trace);
        return true;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode mdxOperator;
        OperatorNode operator = (OperatorNode)node;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        switch (operator.getOperatorType()) {
            case AND: {
                mdxOperator = nodeFactory.createNode(2035);
                break;
            }
            case OR: {
                mdxOperator = nodeFactory.createNode(2036);
                break;
            }
            case EQUALS: {
                MDXComparisonOperator compOp = (MDXComparisonOperator)nodeFactory.createNode(2038);
                compOp.setOperatorType(1);
                mdxOperator = compOp;
                break;
            }
            case GREATER_THAN: {
                MDXComparisonOperator compOp = (MDXComparisonOperator)nodeFactory.createNode(2038);
                compOp.setOperatorType(3);
                mdxOperator = compOp;
                break;
            }
            case GREATER_THAN_OR_EQUAL: {
                MDXComparisonOperator compOp = (MDXComparisonOperator)nodeFactory.createNode(2038);
                compOp.setOperatorType(6);
                mdxOperator = compOp;
                break;
            }
            case LESS_THAN: {
                MDXComparisonOperator compOp = (MDXComparisonOperator)nodeFactory.createNode(2038);
                compOp.setOperatorType(4);
                mdxOperator = compOp;
                break;
            }
            case LESS_THAN_OR_EQUAL: {
                MDXComparisonOperator compOp = (MDXComparisonOperator)nodeFactory.createNode(2038);
                compOp.setOperatorType(5);
                mdxOperator = compOp;
                break;
            }
            case NOT_EQUALS: {
                MDXComparisonOperator compOp = (MDXComparisonOperator)nodeFactory.createNode(2038);
                compOp.setOperatorType(2);
                mdxOperator = compOp;
                break;
            }
            case PLUS: {
                MDXNumericOperator numOp = (MDXNumericOperator)nodeFactory.createNode(2037);
                numOp.setOperatorProperty(1);
                mdxOperator = numOp;
                break;
            }
            case MINUS: {
                MDXNumericOperator numOp = (MDXNumericOperator)nodeFactory.createNode(2037);
                numOp.setOperatorProperty(0);
                mdxOperator = numOp;
                break;
            }
            case MULTIPLY: {
                MDXNumericOperator numOp = (MDXNumericOperator)nodeFactory.createNode(2037);
                numOp.setOperatorProperty(3);
                mdxOperator = numOp;
                break;
            }
            case DIVIDE: {
                MDXNumericOperator numOp = (MDXNumericOperator)nodeFactory.createNode(2037);
                numOp.setOperatorProperty(2);
                mdxOperator = numOp;
                break;
            }
            case NEGATE: {
                MDXNumericOperator numOp = (MDXNumericOperator)nodeFactory.createNode(2037);
                numOp.setOperatorProperty(5);
                mdxOperator = numOp;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        node.exchange(mdxOperator, true);
    }
}

