/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.olap;

import com.ibm.cognos.aurora.api.model.IAttribute;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.IMember;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalMetadata;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.IAttributeSelection;
import com.ibm.cognos.aurora.api.query.queryspec.expression.ESetFunction;
import com.ibm.cognos.aurora.api.query.queryspec.expression.IExpression;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.rules.AbstractRule;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.core.model.DateHierarchyHelper;
import com.ibm.cognos.aurora.qls.model.physical.olap.OlapLevel;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.BaseLevel;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.BaseMember;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXPeriodsToDate;
import com.ibm.cognos.aurora.qls.query.planner.rules.olap.OLAPQueryRule;
import com.ibm.cognos.aurora.qls.query.queryspec.SetFunction;

public class ConvertSetFunctionToPeriodsToDateMDXFunction
extends OLAPQueryRule {
    public ConvertSetFunctionToPeriodsToDateMDXFunction() {
        this.mName = "Convert time periods related functions to the MDX PeriodsToDate function";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{14};
        this.mMode = AbstractRule.Mode.TOP_DOWN;
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!ConvertSetFunctionToPeriodsToDateMDXFunction.hasOLAPDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with an OLAP data source.", trace);
            return false;
        }
        SetFunction setFunction = (SetFunction)node;
        ESetFunction functionType = setFunction.getFunctionType();
        if (functionType == ESetFunction.QTD || functionType == ESetFunction.YTD || functionType == ESetFunction.MTD) {
            this.traceNodeCondition(true, "The relative time functions need to be converted to the MDX PeriodsToDate", trace);
            return true;
        }
        this.traceNodeCondition(false, "The node is not a relative time.", trace);
        return false;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SetFunction setFunction = (SetFunction)node;
        MDXPeriodsToDate periodsToDate = (MDXPeriodsToDate)nodeFactory.createNode(2033);
        IExpression expression = setFunction.getParameters()[0];
        if (!(expression instanceof IAttributeSelection)) {
            throw new UnsupportedOperationException();
        }
        IAttributeSelection attributeSelection = (IAttributeSelection)expression;
        IAttribute attribute = attributeSelection.getIAttribute();
        DateHierarchyHelper dateHelper = DateHierarchyHelper.forTemporalAttribute((INode)attribute.getNode());
        INode functionAttribute = null;
        switch (setFunction.getFunctionType()) {
            case YTD: {
                functionAttribute = dateHelper.getYearIdentifier();
                break;
            }
            case QTD: {
                functionAttribute = dateHelper.getQuarterIdentifier();
                break;
            }
            case MTD: {
                functionAttribute = dateHelper.getMonthIdentifier();
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (functionAttribute == null) {
            throw new IllegalStateException();
        }
        IDataItem dataItem = functionAttribute.getDataItem();
        IPhysicalMetadata physicalMetadata = dataItem.getPhysicalMetadata();
        String lun = null;
        switch (physicalMetadata.getType()) {
            case OLAP_LEVEL: {
                OlapLevel physicalLevel = (OlapLevel)physicalMetadata;
                lun = physicalLevel.getUniqueName();
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        IMember member = setFunction.getContext()[0];
        String mun = member.getUniqueName();
        BaseMember mdxMember = (BaseMember)nodeFactory.createNode(2010);
        mdxMember.setMemberUniqueName(mun);
        BaseLevel level = (BaseLevel)nodeFactory.createNode(2008);
        level.setLevelUniqueName(lun);
        level.setPropertyValue("membersProjected", true);
        this.replaceCurrentSelection(node, periodsToDate, nodeFactory);
        periodsToDate.addChild(level);
        periodsToDate.addChild(mdxMember);
    }
}

