/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.olap;

import com.ibm.cognos.aurora.api.model.ESortDirection;
import com.ibm.cognos.aurora.api.query.queryspec.actions.ISortKey;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXOrder;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXTuple;
import com.ibm.cognos.aurora.qls.query.planner.rules.olap.ContextDependentRule;
import com.ibm.cognos.aurora.qls.query.queryspec.SortByData;

public class ConvertSortByDataToOrderMDXFunction
extends ContextDependentRule {
    public ConvertSortByDataToOrderMDXFunction() {
        this.mName = "Replace set or axis action SortByData with the MDX Order function.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{21};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        int parentType = node.getParent().getType();
        if (parentType == 3 || parentType == 2) {
            this.traceNodeCondition(true, "The SortByData set/axis action needs to be converted to an MDX Order.", trace);
            return true;
        }
        this.traceNodeCondition(true, "The SortByData node is not a set/axis action.", trace);
        return false;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        SortByData sortNode;
        ISortKey key = (ISortKey)node.getFirstChildByType(16);
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MDXOrder mdxOrder = (MDXOrder)nodeFactory.createNode(2022, node);
        this.wrapSetsOrSelections(node, mdxOrder, nodeFactory);
        MDXTuple mdxTuple = this.constructContextTuple(node, nodeFactory);
        mdxOrder.addChild(mdxTuple);
        int sortType = key == null ? MDXOrder.determineSortType((sortNode = (SortByData)node).getSortDirection() == ESortDirection.Ascending, sortNode.isKeepHierarchy()) : MDXOrder.determineSortType(key);
        mdxOrder.setOrderingProperty(sortType);
    }
}

