/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.olap;

import com.ibm.cognos.aurora.api.query.queryspec.expression.ESetFunction;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.rules.AbstractRule;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXTopBottomFunction;
import com.ibm.cognos.aurora.qls.query.planner.rules.olap.OLAPQueryRule;
import com.ibm.cognos.aurora.qls.query.queryspec.SetFunction;

public class ConvertTopBottomToMDXTopBottomFunction
extends OLAPQueryRule {
    public ConvertTopBottomToMDXTopBottomFunction() {
        this.mName = "Convert Top/Bottom Count to the MDX Top/Bottom function";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{14};
        this.mMode = AbstractRule.Mode.TOP_DOWN;
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!ConvertTopBottomToMDXTopBottomFunction.hasOLAPDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with an OLAP data source.", trace);
            return false;
        }
        SetFunction setFunction = (SetFunction)node;
        ESetFunction functionType = setFunction.getFunctionType();
        if (functionType == ESetFunction.TOPCOUNT || functionType == ESetFunction.BOTTOMCOUNT) {
            this.traceNodeCondition(true, "The top/bottom function needs to be converted to the MDX Top/Bottom count", trace);
            return true;
        }
        this.traceNodeCondition(false, "The node is not a top/bottom function.", trace);
        return false;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SetFunction setFunction = (SetFunction)node;
        MDXTopBottomFunction mdxTopBottom = (MDXTopBottomFunction)nodeFactory.createNode(2030);
        switch (setFunction.getFunctionType()) {
            case TOPCOUNT: {
                mdxTopBottom.setOperatorType(1);
                break;
            }
            case BOTTOMCOUNT: {
                mdxTopBottom.setOperatorType(4);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        this.wrapCurrentSelection(node, mdxTopBottom, nodeFactory);
        IXQEQueryNode countConstant = setFunction.getChild(0);
        IXQEQueryNode measureMember = setFunction.getChild(1);
        countConstant.move((IXQEQueryNode)mdxTopBottom);
        measureMember.move((IXQEQueryNode)mdxTopBottom);
    }
}

