/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.olap;

import com.ibm.cognos.aurora.api.model.physical.olap.IOlapCube;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapModel;
import com.ibm.cognos.aurora.api.query.queryspec.IAxisSpecification;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXFromCube;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXQuery;
import com.ibm.cognos.aurora.qls.query.planner.rules.olap.OLAPQueryRule;

public class ConvertViewToMDXQuery
extends OLAPQueryRule {
    public ConvertViewToMDXQuery() {
        this.mName = "Convert a QuerySpec View to a MDX Query.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{1};
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getType() == 1) {
            if (!ConvertViewToMDXQuery.hasOLAPDataSource(node)) {
                this.traceNodeCondition(false, "Node is not associated with an OLAP data source.", trace);
                return false;
            }
            this.traceNodeCondition(true, "ViewSpecification needs to be converted to a MDXQuery.", trace);
            return true;
        }
        this.traceNodeCondition(false, "Node is not of type ViewSpecification", trace);
        return false;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IOlapModel olapModel = (IOlapModel)ConvertViewToMDXQuery.getPhysicalModel(node);
        IOlapCube cube = (IOlapCube)olapModel.getCubes().get(0);
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MDXQuery mdxQueryNode = (MDXQuery)nodeFactory.createNode(2000, node);
        MDXFromCube mdxFromNode = (MDXFromCube)nodeFactory.createNode(2001);
        mdxFromNode.setOlapModel(olapModel);
        mdxFromNode.setCatalogName(cube.getCatalogName());
        mdxFromNode.setCubeName(cube.getName());
        int[] axisLimits = this.getAxisLimits(node);
        if (axisLimits != null) {
            mdxQueryNode.setPropertyValue("axisTupleLimits", axisLimits);
        }
        node.exchange((IXQEQueryNode)mdxQueryNode, true);
        mdxQueryNode.addChild(mdxFromNode);
    }

    private int[] getAxisLimits(IXQEQueryNode node) {
        IXQEQueryNode[] axisNodes = node.getChildrenOfTypeOrdered(2);
        int[] limits = new int[axisNodes.length];
        for (int i = 0; i < limits.length; ++i) {
            IAxisSpecification axisSpec = (IAxisSpecification)axisNodes[i];
            Integer tupleLimit = (Integer)axisSpec.getOption(IAxisSpecification.AxisOption.LIMIT_TUPLES);
            if (tupleLimit == null) {
                return null;
            }
            limits[i] = tupleLimit;
        }
        return limits;
    }
}

