/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.olap;

import com.ibm.cognos.aurora.api.model.IHierarchy;
import com.ibm.cognos.aurora.api.model.IMember;
import com.ibm.cognos.aurora.api.query.queryspec.expression.ESetFunction;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.exception.QLSMessageKeys;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.BaseMember;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXHierarchize;
import com.ibm.cognos.aurora.qls.query.planner.rules.olap.OLAPQueryRule;
import com.ibm.cognos.aurora.qls.query.queryspec.SetFunction;

public class EvaluateDrills
extends OLAPQueryRule {
    private static final String EVALUATED = "evaluated";

    public EvaluateDrills() {
        this.mName = "Evaluate drill up and down actions";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{4};
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!EvaluateDrills.hasOLAPDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with an OLAP data source.", trace);
            return false;
        }
        Object o = node.getPropertyValue(EVALUATED);
        if (o == null) {
            this.traceNodeCondition(true, "Drills need to be evaluated.", trace);
            return true;
        }
        this.traceNodeCondition(false, "Drills have been evaluated.", trace);
        return false;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode[] children = node.getChildrenOfType(14);
        if (children == null || children.length == 0) {
            node.setPropertyValue(EVALUATED, (Object)Boolean.TRUE);
            return;
        }
        for (int i = 0; i < children.length; ++i) {
            boolean includeParent;
            IXQEQueryNode aNode = children[i];
            if (aNode.getType() != 14) continue;
            SetFunction setFunction = (SetFunction)aNode;
            if (setFunction.getFunctionType() != ESetFunction.DRILLDOWN && setFunction.getFunctionType() != ESetFunction.DRILLUP) {
                node.setPropertyValue(EVALUATED, (Object)Boolean.TRUE);
                continue;
            }
            IMember[] members = setFunction.getContext();
            if (members == null) {
                throw new IllegalStateException();
            }
            Boolean includeParentObj = setFunction.getBooleanPropertyValue("showParentMembers");
            boolean bl = includeParent = includeParentObj != null && includeParentObj != false;
            if (members == null) continue;
            int childPos = node.getPositionOfChild((IXQEQueryNode)setFunction);
            this.removeAllChildNodesBefore(node, childPos);
            if (members.length == 1) {
                this.singleMemberDrill(nodeFactory, setFunction, aNode, members, includeParent);
                continue;
            }
            if (members.length <= 1) continue;
            if (setFunction.getFunctionType() == ESetFunction.DRILLDOWN) {
                this.multipleMembersDrilldown(nodeFactory, setFunction, aNode, members, includeParent);
                continue;
            }
            if (setFunction.getFunctionType() != ESetFunction.DRILLUP) continue;
            this.multipleMembersDrillup(nodeFactory, setFunction, aNode, members, includeParent);
        }
    }

    private void singleMemberDrill(XQENodeFactory nodeFactory, SetFunction setFunction, IXQEQueryNode node, IMember[] members, boolean includeParent) {
        int childPos = node.getPositionOfChild((IXQEQueryNode)setFunction);
        this.removeAllChildNodesBefore(node, childPos);
        IXQEQueryNode set = nodeFactory.createNode(2004);
        setFunction.exchange(set);
        BaseMember member = this.createBaseMemberFromMUN(nodeFactory, members[0].getUniqueName());
        IXQEQueryNode mdxSetFunction = null;
        if (setFunction.getFunctionType() == ESetFunction.DRILLDOWN) {
            if (members[0].getChildMembers().size() != 0) {
                if (includeParent) {
                    member = this.createBaseMemberFromMUN(nodeFactory, members[0].getUniqueName());
                    set.addChild((IXQEQueryNode)member);
                }
                mdxSetFunction = nodeFactory.createNode(2018);
                mdxSetFunction.addChild((IXQEQueryNode)member);
                set.addChild(mdxSetFunction);
            } else {
                if (includeParent) {
                    IXQEQueryNode parent = nodeFactory.createNode(2019);
                    set.addChild(parent);
                    parent.addChild((IXQEQueryNode)member);
                }
                member = this.createBaseMemberFromMUN(nodeFactory, members[0].getUniqueName());
                set.addChild((IXQEQueryNode)member);
            }
        } else {
            if (includeParent) {
                IXQEQueryNode parentOfParent = nodeFactory.createNode(2019);
                set.addChild(parentOfParent);
                IXQEQueryNode parent = nodeFactory.createNode(2019);
                parentOfParent.addChild(parent);
                member = this.createBaseMemberFromMUN(nodeFactory, members[0].getUniqueName());
                parent.addChild((IXQEQueryNode)member);
            }
            mdxSetFunction = nodeFactory.createNode(2020);
            IXQEQueryNode parent = nodeFactory.createNode(2019);
            mdxSetFunction.addChild(parent);
            parent.addChild((IXQEQueryNode)member);
            set.addChild(mdxSetFunction);
        }
    }

    private void multipleMembersDrilldown(XQENodeFactory nodeFactory, SetFunction setFunction, IXQEQueryNode selectionSpec, IMember[] members, boolean showParentMember) {
        IXQEQueryNode mdxCurrentMember;
        MDXHierarchize mdxHierarchize = (MDXHierarchize)nodeFactory.createNode(2017);
        setFunction.exchange(mdxHierarchize);
        IXQEQueryNode nonLeaf = nodeFactory.createNode(2004);
        IXQEQueryNode leaf = nodeFactory.createNode(2004);
        IHierarchy hierarchy = null;
        for (IMember member : members) {
            if (hierarchy == null) {
                hierarchy = member.getHierarchy();
            }
            if (member.getHierarchy() != hierarchy) {
                throw new QLSRuntimeException(QLSMessageKeys.EXE_UnsupportedDrillContext);
            }
            BaseMember baseMember = this.createBaseMemberFromMUN(nodeFactory, member.getUniqueName());
            if (!member.getChildMembers().isEmpty()) {
                nonLeaf.addChild((IXQEQueryNode)baseMember);
                continue;
            }
            leaf.addChild((IXQEQueryNode)baseMember);
        }
        IXQEQueryNode mdxGenerateNonLeaf = null;
        if (nonLeaf.getNumberChildren() != 0) {
            mdxGenerateNonLeaf = nodeFactory.createNode(2045);
            mdxGenerateNonLeaf.addChild(nonLeaf);
            IXQEQueryNode currentMemberSet = nodeFactory.createNode(2004);
            mdxGenerateNonLeaf.addChild(currentMemberSet);
            if (showParentMember) {
                IXQEQueryNode mdxCurrentMember2 = this.buildMDXCurrentMemberExpr(nodeFactory, hierarchy);
                currentMemberSet.addChild(mdxCurrentMember2);
            }
            IXQEQueryNode childrenFunction = nodeFactory.createNode(2018);
            currentMemberSet.addChild(childrenFunction);
            mdxCurrentMember = this.buildMDXCurrentMemberExpr(nodeFactory, hierarchy);
            childrenFunction.addChild(mdxCurrentMember);
        }
        IXQEQueryNode mdxGenerateLeaf = null;
        if (leaf.getNumberChildren() != 0) {
            mdxGenerateLeaf = nodeFactory.createNode(2045);
            mdxGenerateLeaf.addChild(leaf);
            IXQEQueryNode currentMemberSet = nodeFactory.createNode(2004);
            mdxGenerateLeaf.addChild(currentMemberSet);
            if (showParentMember) {
                IXQEQueryNode parentFunction = nodeFactory.createNode(2019);
                currentMemberSet.addChild(parentFunction);
                IXQEQueryNode mdxCurrentMember3 = this.buildMDXCurrentMemberExpr(nodeFactory, hierarchy);
                parentFunction.addChild(mdxCurrentMember3);
            }
            mdxCurrentMember = this.buildMDXCurrentMemberExpr(nodeFactory, hierarchy);
            currentMemberSet.addChild(mdxCurrentMember);
        }
        if (leaf.getNumberChildren() != 0 && nonLeaf.getNumberChildren() != 0) {
            IXQEQueryNode union = nodeFactory.createNode(2046);
            mdxHierarchize.addChild(union);
            union.addChild(mdxGenerateLeaf);
            union.addChild(mdxGenerateNonLeaf);
        } else if (mdxGenerateLeaf != null) {
            mdxHierarchize.addChild(mdxGenerateLeaf);
        } else {
            mdxHierarchize.addChild(mdxGenerateNonLeaf);
        }
    }

    private void multipleMembersDrillup(XQENodeFactory nodeFactory, SetFunction setFunction, IXQEQueryNode node, IMember[] members, boolean includeParent) {
        MDXHierarchize mdxHierarchize = (MDXHierarchize)nodeFactory.createNode(2017);
        setFunction.exchange(mdxHierarchize);
        IXQEQueryNode hierarchizedSet = nodeFactory.createNode(2004);
        mdxHierarchize.addChild(hierarchizedSet);
        IXQEQueryNode memberSet = nodeFactory.createNode(2004);
        IHierarchy hierarchy = null;
        for (IMember member : members) {
            if (hierarchy == null) {
                hierarchy = member.getHierarchy();
            }
            if (member.getHierarchy() != hierarchy) {
                throw new QLSRuntimeException(QLSMessageKeys.EXE_UnsupportedDrillHierarchy);
            }
            if (member.getParentMember() == null) {
                throw new QLSRuntimeException(QLSMessageKeys.EXE_UnsupportedOperationDrillUpOnRootMember);
            }
            BaseMember baseMember = this.createBaseMemberFromMUN(nodeFactory, member.getUniqueName());
            memberSet.addChild((IXQEQueryNode)baseMember);
        }
        IXQEQueryNode mdxGenerate = nodeFactory.createNode(2045);
        hierarchizedSet.addChild(mdxGenerate);
        mdxGenerate.addChild(memberSet);
        IXQEQueryNode currentMemberSet = nodeFactory.createNode(2004);
        mdxGenerate.addChild(currentMemberSet);
        if (includeParent) {
            IXQEQueryNode parentOfParentFunction = nodeFactory.createNode(2019);
            currentMemberSet.addChild(parentOfParentFunction);
            IXQEQueryNode parent = nodeFactory.createNode(2019);
            parentOfParentFunction.addChild(parent);
            IXQEQueryNode mdxCurrentMember1 = this.buildMDXCurrentMemberExpr(nodeFactory, hierarchy);
            parent.addChild(mdxCurrentMember1);
        }
        IXQEQueryNode ParentAndSiblingsFunction = nodeFactory.createNode(2020);
        IXQEQueryNode parentFunction = nodeFactory.createNode(2019);
        ParentAndSiblingsFunction.addChild(parentFunction);
        IXQEQueryNode mdxCurrentMember = this.buildMDXCurrentMemberExpr(nodeFactory, hierarchy);
        parentFunction.addChild(mdxCurrentMember);
        currentMemberSet.addChild(ParentAndSiblingsFunction);
    }

    private BaseMember createBaseMemberFromMUN(XQENodeFactory nodeFactory, String mun) {
        BaseMember member = (BaseMember)nodeFactory.createNode(2010);
        member.setMeasure(false);
        member.setMemberUniqueName(mun);
        return member;
    }
}

