/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.olap;

import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.rules.AbstractRule;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.query.planner.rules.olap.OLAPQueryRule;

public class InsertSelectAllSelectionAction
extends OLAPQueryRule {
    public InsertSelectAllSelectionAction() {
        this.mName = "Insert SelectAll action to empty selection specification.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{4};
        this.mMode = AbstractRule.Mode.INDEXED;
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!InsertSelectAllSelectionAction.hasOLAPDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with an OLAP data source.", trace);
            return false;
        }
        IXQEQueryNode[] selectionActions = node.getChildren();
        if (selectionActions == null || selectionActions.length < 1) {
            this.traceNodeCondition(true, "No selection action exists.  Need to insert a default action.", trace);
            return true;
        }
        this.traceNodeCondition(false, "Selection actions exist.", trace);
        return false;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode selectAllAction = nodeFactory.createNode(18);
        node.addChild(selectAllAction);
    }
}

