/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.olap;

import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.query.planner.rules.olap.OLAPQueryRule;

public class ProjectMembersForMDXBaseLevelOrHierarchy
extends OLAPQueryRule {
    public static final String SUPPRESS_MEMBERS_PROJECTION = "suppressMembersProjection";
    public static final String MEMBERS_PROJECTED = "membersProjected";

    public ProjectMembersForMDXBaseLevelOrHierarchy() {
        this.mName = "Project members for a level reference in the query.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{2008, 2012};
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!ProjectMembersForMDXBaseLevelOrHierarchy.hasOLAPDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with an OLAP data source.", trace);
            return false;
        }
        if (null != node.getPropertyValue(SUPPRESS_MEMBERS_PROJECTION)) {
            this.traceNodeCondition(true, "Members function was suppressed", trace);
            return false;
        }
        if (null == node.getPropertyValue(MEMBERS_PROJECTED)) {
            this.traceNodeCondition(true, "Members for the given level/hierarchy need to be projected", trace);
            return true;
        }
        this.traceNodeCondition(true, "Members function has already been created", trace);
        return false;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode mdxMembers = nodeFactory.createNode(2006, node);
        IXQEQueryNode parent = node.getParent();
        int position = parent.getPositionOfChild(node);
        parent.addChild(mdxMembers, position);
        node.detach();
        mdxMembers.addChild(node);
        node.setPropertyValue(MEMBERS_PROJECTED, (Object)Boolean.TRUE);
    }
}

