/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.olap;

import com.ibm.cognos.aurora.api.query.queryspec.expression.ESetFunction;
import com.ibm.cognos.aurora.api.query.queryspec.expression.ISetFunction;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.query.planner.rules.olap.OLAPQueryRule;

public class RemoveRedundantSortByAttribute
extends OLAPQueryRule {
    private static final String SORTS_OPTIMIZED = "sortsOptimized";

    public RemoveRedundantSortByAttribute() {
        this.mName = "Optimize SortByAttribute selection actions to remove redundant ones.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{4};
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!RemoveRedundantSortByAttribute.hasOLAPDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with an OLAP data source.", trace);
            return false;
        }
        Object o = node.getPropertyValue(SORTS_OPTIMIZED);
        if (o == null) {
            this.traceNodeCondition(true, "Sort by attribute actions need to be optimized.", trace);
            return true;
        }
        this.traceNodeCondition(false, "Sort by attribute actions have already been optimized.", trace);
        return false;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] selectionActions = node.getChildren();
        int numActions = selectionActions.length;
        for (int i = 0; i < numActions; ++i) {
            int next;
            IXQEQueryNode action = selectionActions[i];
            if (action.getType() != 23 || (next = i + 1) >= numActions || !this.isCurrentNodeRedunant(selectionActions[next])) continue;
            action.detach();
        }
        node.setPropertyValue(SORTS_OPTIMIZED, (Object)Boolean.TRUE);
    }

    private boolean isCurrentNodeRedunant(IXQEQueryNode nextNode) {
        boolean redundant = false;
        switch (nextNode.getType()) {
            case 23: {
                redundant = true;
                break;
            }
            case 14: {
                ISetFunction setFunction = (ISetFunction)nextNode;
                ESetFunction functionType = setFunction.getFunctionType();
                if (functionType != ESetFunction.TOPCOUNT && functionType != ESetFunction.BOTTOMCOUNT) break;
                redundant = true;
                break;
            }
        }
        return redundant;
    }
}

