/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.sql;

import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.query.queryspec.actions.ISelectionAction;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.INodesSelection;
import com.ibm.cognos.aurora.api.query.queryspec.expression.ESetFunction;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.core.model.DateHierarchyHelper;
import com.ibm.cognos.aurora.core.model.MetadataHelper;
import com.ibm.cognos.aurora.core.model.RelationalDataItems;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLColumn;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLComparison;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLLiteral;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLLogical;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLRangeVar;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLRelation;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLSelect;
import com.ibm.cognos.aurora.qls.query.planner.rules.sql.SQLQueryRule;
import com.ibm.cognos.aurora.qls.query.planner.rules.sql.util.SQLUtil;
import com.ibm.cognos.aurora.qls.query.queryspec.SelectionActionCategory;
import com.ibm.cognos.aurora.qls.query.queryspec.SelectionSpecification;
import com.ibm.cognos.aurora.qls.query.queryspec.SetFunction;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;

public class BuildSQLForDrillup
extends SQLQueryRule {
    public BuildSQLForDrillup() {
        this.mName = "Construct SQL for drillup set function.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{14};
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        if (!BuildSQLForDrillup.hasRelationalDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with a relational data source.", trace);
            return false;
        }
        ESetFunction type = ((SetFunction)node).getFunctionType();
        IXQEQueryNode selectNode = node.getAncestorOfType(3026);
        boolean bl = status = type == ESetFunction.DRILLUP && selectNode.getChildrenOfType(3021).length > 0;
        if (status) {
            this.traceNodeCondition(true, "SQL needs to be constructed for drillup set function.", trace);
        } else {
            this.traceNodeCondition(false, "SQL does not need to be constructed for drillup set function.", trace);
        }
        return status;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        String tableName;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLSelect selectNode = (SQLSelect)node.getAncestorOfType(3026);
        IXQEQueryNode productNode = selectNode.getChildrenOfType(3021)[0];
        IXQEQueryNode filterNode = null;
        Object[] children = selectNode.getChildrenOfType(3009);
        if (children.length > 0) {
            filterNode = children[0];
        }
        SelectionSpecification selection = (SelectionSpecification)node.getAncestorOfType(4);
        children = selection.getChildren();
        int index = ArrayUtils.indexOf((Object[])children, (Object)node);
        SQLColumn column = (SQLColumn)children[index - 1];
        INode category = column.getNode();
        List<INode> hierarchy = column.getHierarchy();
        INode parent = hierarchy.get(hierarchy.indexOf(category) - 1);
        ISelectionAction aSelection = (ISelectionAction)node.getChild(0).detach();
        if (aSelection instanceof SelectionActionCategory) {
            category = ((SelectionActionCategory)aSelection).getCategory();
        } else if (aSelection instanceof INodesSelection) {
            INode[] selectedNodes = ((INodesSelection)aSelection).getNodes();
            category = selectedNodes[0];
        }
        ArrayList<SQLComparison> predicates = new ArrayList<SQLComparison>();
        IDataItem dataItem = MetadataHelper.getDefaultDataItem((INode)category);
        if (category.getConcept().isTemporal()) {
            DateHierarchyHelper dateHelper = DateHierarchyHelper.forTemporalCategory((INode)category);
            tableName = (String)dateHelper.getDateCategory().getProperty("__calendarTable");
        } else {
            tableName = RelationalDataItems.getTableName((IDataItem)dataItem);
        }
        SQLRelation relation = (SQLRelation)nodeFactory.createNode(3024);
        relation.setTableName(tableName);
        String name = String.format("T%d", productNode.getNumberChildren());
        SQLRangeVar rangeVar = (SQLRangeVar)nodeFactory.createNode(3023);
        rangeVar.setName(name);
        rangeVar.addChild(relation);
        productNode.addChild((IXQEQueryNode)rangeVar);
        SQLColumn lChild = SQLUtil.createSQLColumn(nodeFactory, name, RelationalDataItems.getColumnName((IDataItem)dataItem));
        SQLLiteral rChild = (SQLLiteral)node.getChild(0).detach();
        SQLComparison vExpr = (SQLComparison)nodeFactory.createNode(3005);
        vExpr.setSubType(SQLComparison.SubType.EQUAL);
        vExpr.addChild(lChild);
        vExpr.addChild(rChild);
        predicates.add(vExpr);
        dataItem = MetadataHelper.getDefaultDataItem((INode)parent);
        String colName = RelationalDataItems.getColumnName((IDataItem)dataItem);
        List<String> tables = selectNode.getTables();
        tableName = String.format("T%d", tables.indexOf(tableName));
        vExpr = (SQLComparison)nodeFactory.createNode(3005);
        vExpr.setSubType(SQLComparison.SubType.EQUAL);
        vExpr.addChild(SQLUtil.createSQLColumn(nodeFactory, tableName, colName));
        vExpr.addChild(SQLUtil.createSQLColumn(nodeFactory, name, colName));
        predicates.add(vExpr);
        IXQEQueryNode predicate = null;
        for (int i = 0; i < predicates.size(); ++i) {
            if (null == predicate) {
                predicate = (IXQEQueryNode)predicates.get(i);
                continue;
            }
            SQLLogical logical = (SQLLogical)nodeFactory.createNode(3019);
            logical.setSubType(SQLLogical.SubType.AND);
            logical.addChild(predicate);
            logical.addChild((IXQEQueryNode)predicates.get(i));
            predicate = logical;
        }
        if (filterNode == null) {
            filterNode = nodeFactory.createNode(3009);
            filterNode.addChild(predicate);
            selectNode.addChild(filterNode);
        } else {
            SQLLogical logical = (SQLLogical)nodeFactory.createNode(3019);
            logical.setSubType(SQLLogical.SubType.AND);
            filterNode.getChild(0).insertParent((IXQEQueryNode)logical);
            logical.addChild(predicate);
        }
        if (node.getNumberChildren() > 0) {
            node.getChild(0).extract();
        }
        node.extract();
    }
}

