/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.sql;

import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.query.queryspec.expression.ESetFunction;
import com.ibm.cognos.aurora.api.query.queryspec.expression.IQuerySpecAttributeValue;
import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.core.model.DateHierarchyHelper;
import com.ibm.cognos.aurora.core.model.MetadataHelper;
import com.ibm.cognos.aurora.core.model.RelationalDataItems;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLAbstractFunction;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLColumn;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLComparison;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLLiteral;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLLogical;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLRangeVar;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLRelation;
import com.ibm.cognos.aurora.qls.query.planner.rules.sql.SQLQueryRule;
import com.ibm.cognos.aurora.qls.query.planner.rules.sql.util.SQLUtil;
import com.ibm.cognos.aurora.qls.query.queryspec.SetFunction;
import java.util.ArrayList;

public class BuildSQLForTimeSeriesFunctions
extends SQLQueryRule {
    public BuildSQLForTimeSeriesFunctions() {
        this.mName = "Construct SQL for time series set functions.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{14};
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        if (!BuildSQLForTimeSeriesFunctions.hasRelationalDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with a relational data source.", trace);
            return false;
        }
        ESetFunction type = ((SetFunction)node).getFunctionType();
        IXQEQueryNode selectNode = node.getAncestorOfType(3026);
        boolean bl = status = (type == ESetFunction.YTD || type == ESetFunction.QTD || type == ESetFunction.MTD) && selectNode.getChildrenOfType(3021).length > 0;
        if (status) {
            this.traceNodeCondition(true, "SQL needs to be constructed for time series set functions.", trace);
        } else {
            this.traceNodeCondition(false, "SQL does not need to be constructed for time series set functions.", trace);
        }
        return status;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SetFunction function = (SetFunction)node;
        IXQEQueryNode selectNode = node.getAncestorOfType(3026);
        IXQEQueryNode productNode = selectNode.getChildrenOfType(3021)[0];
        IXQEQueryNode filterNode = null;
        IXQEQueryNode[] children = selectNode.getChildrenOfType(3009);
        if (children.length > 0) {
            filterNode = children[0];
        }
        ArrayList<SQLAbstractFunction> predicates = new ArrayList<SQLAbstractFunction>();
        IQuerySpecAttributeValue attrValue = (IQuerySpecAttributeValue)function.getChild(0).extract();
        INode category = attrValue.getAttribute();
        IConcept concept = category.getConcept();
        DateHierarchyHelper dateHelper = DateHierarchyHelper.forTemporalCategory((INode)category);
        String calTableIdent = (String)dateHelper.getDateCategory().getProperty("__calendarTable");
        assert (null != calTableIdent);
        SQLRelation relation = (SQLRelation)nodeFactory.createNode(3024);
        relation.setTableName(calTableIdent);
        String name = String.format("T%d", productNode.getNumberChildren());
        SQLRangeVar rangeVar = (SQLRangeVar)nodeFactory.createNode(3023);
        rangeVar.setName(name);
        rangeVar.addChild(relation);
        productNode.addChild((IXQEQueryNode)rangeVar);
        IValue value = attrValue.getValue();
        IDataItem dataItem = MetadataHelper.getDefaultDataItem((INode)category);
        SQLColumn lChild = SQLUtil.createSQLColumn(nodeFactory, name, RelationalDataItems.getColumnName((IDataItem)dataItem));
        SQLLiteral rChild = (SQLLiteral)nodeFactory.createNode(3018);
        rChild.setValue(value);
        SQLComparison vExpr = (SQLComparison)nodeFactory.createNode(3005);
        vExpr.setSubType(SQLComparison.SubType.EQUAL);
        vExpr.addChild(lChild);
        vExpr.addChild(rChild);
        predicates.add(vExpr);
        String yearColName = RelationalDataItems.getColumnName((IDataItem)dateHelper.getYearIdentifier().getDataItem());
        String quarterColName = RelationalDataItems.getColumnName((IDataItem)dateHelper.getQuarterIdentifier().getDataItem());
        String monthColName = RelationalDataItems.getColumnName((IDataItem)dateHelper.getMonthIdentifier().getDataItem());
        String dayOfMonthColName = RelationalDataItems.getColumnName((IDataItem)dateHelper.getDayOfMonthIdentifier().getDataItem());
        vExpr = (SQLComparison)nodeFactory.createNode(3005);
        vExpr.setSubType(SQLComparison.SubType.EQUAL);
        vExpr.addChild(SQLUtil.createSQLColumn(nodeFactory, "T1", yearColName));
        vExpr.addChild(SQLUtil.createSQLColumn(nodeFactory, name, yearColName));
        predicates.add(vExpr);
        switch (function.getFunctionType()) {
            case YTD: {
                SQLLogical lExpr2;
                SQLLogical lExpr1;
                SQLComparison cExpr2;
                SQLComparison cExpr1;
                String cName = null;
                if (concept.getName().equals("cDayOfMonth")) {
                    vExpr = (SQLComparison)nodeFactory.createNode(3005);
                    vExpr.setSubType(SQLComparison.SubType.LESS);
                    vExpr.addChild(SQLUtil.createSQLColumn(nodeFactory, "T1", monthColName));
                    vExpr.addChild(SQLUtil.createSQLColumn(nodeFactory, name, monthColName));
                    cExpr1 = (SQLComparison)nodeFactory.createNode(3005);
                    cExpr1.setSubType(SQLComparison.SubType.EQUAL);
                    cExpr1.addChild(SQLUtil.createSQLColumn(nodeFactory, "T1", monthColName));
                    cExpr1.addChild(SQLUtil.createSQLColumn(nodeFactory, name, monthColName));
                    cExpr2 = (SQLComparison)nodeFactory.createNode(3005);
                    cExpr2.setSubType(SQLComparison.SubType.LESSEQUAL);
                    cExpr2.addChild(SQLUtil.createSQLColumn(nodeFactory, "T1", dayOfMonthColName));
                    cExpr2.addChild(SQLUtil.createSQLColumn(nodeFactory, name, dayOfMonthColName));
                    lExpr1 = (SQLLogical)nodeFactory.createNode(3019);
                    lExpr1.setSubType(SQLLogical.SubType.AND);
                    lExpr1.addChild(cExpr1);
                    lExpr1.addChild(cExpr2);
                    lExpr2 = (SQLLogical)nodeFactory.createNode(3019);
                    lExpr2.setSubType(SQLLogical.SubType.OR);
                    lExpr2.addChild(vExpr);
                    lExpr2.addChild(lExpr1);
                    predicates.add(lExpr2);
                    break;
                }
                if (concept.getName().equals("cMonth")) {
                    cName = monthColName;
                } else if (concept.getName().equals("cQuarter")) {
                    cName = quarterColName;
                }
                vExpr = (SQLComparison)nodeFactory.createNode(3005);
                vExpr.setSubType(SQLComparison.SubType.LESSEQUAL);
                vExpr.addChild(SQLUtil.createSQLColumn(nodeFactory, "T1", cName));
                vExpr.addChild(SQLUtil.createSQLColumn(nodeFactory, name, cName));
                predicates.add(vExpr);
                break;
            }
            case QTD: {
                SQLLogical lExpr2;
                SQLLogical lExpr1;
                SQLComparison cExpr2;
                SQLComparison cExpr1;
                vExpr = (SQLComparison)nodeFactory.createNode(3005);
                vExpr.setSubType(SQLComparison.SubType.EQUAL);
                vExpr.addChild(SQLUtil.createSQLColumn(nodeFactory, "T1", quarterColName));
                vExpr.addChild(SQLUtil.createSQLColumn(nodeFactory, name, quarterColName));
                predicates.add(vExpr);
                if (concept.getName().equals("cMonth")) {
                    vExpr = (SQLComparison)nodeFactory.createNode(3005);
                    vExpr.setSubType(SQLComparison.SubType.LESSEQUAL);
                    vExpr.addChild(SQLUtil.createSQLColumn(nodeFactory, "T1", monthColName));
                    vExpr.addChild(SQLUtil.createSQLColumn(nodeFactory, name, monthColName));
                    predicates.add(vExpr);
                    break;
                }
                if (concept.getName().equals("cDayOfMonth")) {
                    vExpr = (SQLComparison)nodeFactory.createNode(3005);
                    vExpr.setSubType(SQLComparison.SubType.LESS);
                    vExpr.addChild(SQLUtil.createSQLColumn(nodeFactory, "T1", monthColName));
                    vExpr.addChild(SQLUtil.createSQLColumn(nodeFactory, name, monthColName));
                    cExpr1 = (SQLComparison)nodeFactory.createNode(3005);
                    cExpr1.setSubType(SQLComparison.SubType.EQUAL);
                    cExpr1.addChild(SQLUtil.createSQLColumn(nodeFactory, "T1", monthColName));
                    cExpr1.addChild(SQLUtil.createSQLColumn(nodeFactory, name, monthColName));
                    cExpr2 = (SQLComparison)nodeFactory.createNode(3005);
                    cExpr2.setSubType(SQLComparison.SubType.LESSEQUAL);
                    cExpr2.addChild(SQLUtil.createSQLColumn(nodeFactory, "T1", dayOfMonthColName));
                    cExpr2.addChild(SQLUtil.createSQLColumn(nodeFactory, name, dayOfMonthColName));
                    lExpr1 = (SQLLogical)nodeFactory.createNode(3019);
                    lExpr1.setSubType(SQLLogical.SubType.AND);
                    lExpr1.addChild(cExpr1);
                    lExpr1.addChild(cExpr2);
                    lExpr2 = (SQLLogical)nodeFactory.createNode(3019);
                    lExpr2.setSubType(SQLLogical.SubType.OR);
                    lExpr2.addChild(vExpr);
                    lExpr2.addChild(lExpr1);
                    predicates.add(lExpr2);
                    break;
                }
                predicates.add(vExpr);
                break;
            }
            case MTD: {
                vExpr = (SQLComparison)nodeFactory.createNode(3005);
                vExpr.setSubType(SQLComparison.SubType.EQUAL);
                vExpr.addChild(SQLUtil.createSQLColumn(nodeFactory, "T1", monthColName));
                vExpr.addChild(SQLUtil.createSQLColumn(nodeFactory, name, monthColName));
                if (concept.getName().equals("cDayOfMonth")) {
                    SQLComparison cExpr = (SQLComparison)nodeFactory.createNode(3005);
                    cExpr.setSubType(SQLComparison.SubType.LESSEQUAL);
                    cExpr.addChild(SQLUtil.createSQLColumn(nodeFactory, "T1", dayOfMonthColName));
                    cExpr.addChild(SQLUtil.createSQLColumn(nodeFactory, name, dayOfMonthColName));
                    SQLLogical lExpr1 = (SQLLogical)nodeFactory.createNode(3019);
                    lExpr1.setSubType(SQLLogical.SubType.AND);
                    lExpr1.addChild(vExpr);
                    lExpr1.addChild(cExpr);
                    predicates.add(lExpr1);
                    break;
                }
                predicates.add(vExpr);
            }
        }
        IXQEQueryNode predicate = null;
        for (int i = 0; i < predicates.size(); ++i) {
            if (null == predicate) {
                predicate = (IXQEQueryNode)predicates.get(i);
                continue;
            }
            SQLLogical logical = (SQLLogical)nodeFactory.createNode(3019);
            logical.setSubType(SQLLogical.SubType.AND);
            logical.addChild(predicate);
            logical.addChild((IXQEQueryNode)predicates.get(i));
            predicate = logical;
        }
        if (filterNode == null) {
            filterNode = nodeFactory.createNode(3009);
            filterNode.addChild(predicate);
            selectNode.addChild(filterNode);
        } else {
            SQLLogical logical = (SQLLogical)nodeFactory.createNode(3019);
            logical.setSubType(SQLLogical.SubType.AND);
            filterNode.getChild(0).insertParent((IXQEQueryNode)logical);
            logical.addChild(predicate);
        }
        node.extract();
    }
}

