/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.sql;

import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.core.model.MetadataHelper;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLAlias;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLColumn;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLSelect;
import com.ibm.cognos.aurora.qls.query.planner.rules.sql.SQLQueryRule;
import com.ibm.cognos.aurora.qls.query.planner.rules.sql.util.SQLUtil;
import com.ibm.cognos.aurora.qls.query.queryspec.AxisNodeMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class BuildSQLGroupBy
extends SQLQueryRule {
    public BuildSQLGroupBy() {
        this.mName = "Build a SQLGroupBy node.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{3026};
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        if (!BuildSQLGroupBy.hasRelationalDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with a relational data source.", trace);
            return false;
        }
        boolean bl = status = node.getChildrenOfType(3031).length == 0 && node.getChildrenOfType(3011).length == 0;
        if (status) {
            this.traceNodeCondition(true, "SQLGroupBy node needs to be constructed.", trace);
        } else {
            this.traceNodeCondition(false, "SQLGroupBy node does not need to constructed.", trace);
        }
        return status;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] sqlColumns;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLSelect selectNode = (SQLSelect)node;
        IXQEQueryNode valueList = nodeFactory.createNode(3031);
        IXQEQueryNode groupByList = nodeFactory.createNode(3012);
        HashMap<IDataItem, Integer> mapping = new HashMap<IDataItem, Integer>();
        selectNode.setColumnMapping(mapping);
        ArrayList<IXQEQueryNode> projectables = new ArrayList<IXQEQueryNode>();
        int columnNo = 0;
        for (IXQEQueryNode column : sqlColumns = node.getChildrenOfType(3004)) {
            IXQEQueryNode expr = column.detach();
            projectables.add(columnNo++, expr);
        }
        List selectionSpecs = node.getDescendantsOfTypeOrdered(4, false);
        for (IXQEQueryNode selectionSpec : selectionSpecs) {
            for (IXQEQueryNode child : selectionSpec.getChildren()) {
                if (child.getType() != 3004 && child.getType() != 3000) continue;
                IXQEQueryNode expr = child.detach();
                if (expr.getType() == 3004) {
                    projectables.add(columnNo++, expr);
                    continue;
                }
                if (expr.getType() != 3000) continue;
                projectables.add(expr);
            }
        }
        columnNo = 0;
        for (IXQEQueryNode expr : projectables) {
            IXQEQueryNode column;
            valueList.addChild((IXQEQueryNode)SQLUtil.createAliasNode(nodeFactory, columnNo, expr));
            if (expr.getType() == 3004) {
                column = (SQLColumn)expr;
                groupByList.addChild((IXQEQueryNode)SQLUtil.createSQLColumn(nodeFactory, (SQLColumn)column));
                AxisNodeMap map = column.getAxisNodeMap();
                if (null != map) {
                    column.getAxisNodeMap().setColumnNo(columnNo);
                }
            } else {
                column = (SQLColumn)expr.getChild(0);
            }
            mapping.put(column.getDataItem(), columnNo++);
        }
        selectNode.setColumnMapping(mapping);
        List<INode> extraNodes = selectNode.getExtraNodes();
        for (INode eNode : extraNodes) {
            IDataItem dataItem = MetadataHelper.getDefaultDataItem((INode)eNode);
            SQLColumn columnNode = SQLUtil.createSQLColumn(nodeFactory, dataItem);
            SQLAlias aliasNode = SQLUtil.createAliasNode(nodeFactory, columnNo, columnNode);
            valueList.addChild((IXQEQueryNode)aliasNode);
            if (!mapping.containsKey(dataItem)) {
                mapping.put(dataItem, columnNo++);
            }
            groupByList.addChild((IXQEQueryNode)SQLUtil.createSQLColumn(nodeFactory, dataItem));
        }
        IXQEQueryNode sqlGroup = nodeFactory.createNode(3011);
        sqlGroup.addChild(valueList);
        if (groupByList.getNumberChildren() > 0) {
            sqlGroup.addChild(groupByList);
        }
        node.addChild(sqlGroup);
    }
}

