/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.sql;

import com.ibm.cognos.aurora.api.model.IDataContainer;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.model.datatype.BaseDataType;
import com.ibm.cognos.aurora.api.model.datatype.DateType;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.core.model.MetadataHelper;
import com.ibm.cognos.aurora.core.model.RelationalDataItems;
import com.ibm.cognos.aurora.qls.exception.QLSMessageKeys;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.ISQLQueryNode;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLCast;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLColumn;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLComparison;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLDataType;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLLogical;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLRangeVar;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLRelation;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLSelect;
import com.ibm.cognos.aurora.qls.query.planner.rules.sql.SQLQueryRule;
import com.ibm.cognos.aurora.qls.query.planner.rules.sql.util.SQLUtil;
import java.util.ArrayList;
import java.util.List;

public class BuildSQLProduct
extends SQLQueryRule {
    private static final String SQLPRODUCT_BUILT = "sqlProductBuilt";

    public BuildSQLProduct() {
        this.mName = "Build a SQLProduct node.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{3026};
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!BuildSQLProduct.hasRelationalDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with a relational data source.", trace);
            return false;
        }
        boolean status = false;
        if (node.getPropertyValue(SQLPRODUCT_BUILT) == null) {
            status = true;
        }
        if (status) {
            this.traceNodeCondition(true, "SQLProduct node needs to be constructed.", trace);
        } else {
            this.traceNodeCondition(false, "SQLProduct node has already been constructed.", trace);
        }
        return status;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        int i;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLSelect selectNode = (SQLSelect)node;
        ArrayList<String> tables = new ArrayList<String>();
        ArrayList<IDataContainer> containers = new ArrayList<IDataContainer>();
        List columns = node.getDescendantsOfTypeOrdered(3004, false);
        for (IXQEQueryNode column : columns) {
            IDataItem dataItem = ((SQLColumn)column).getDataItem();
            String tableName = RelationalDataItems.getTableName((IDataItem)dataItem);
            if (tables.contains(tableName)) continue;
            tables.add(tableName);
            if (containers.contains(dataItem.getContainer())) continue;
            containers.add(dataItem.getContainer());
        }
        ArrayList<SQLComparison> predicates = new ArrayList<SQLComparison>();
        for (IDataContainer container : containers) {
            INode dateCat = null;
            for (INode n : container.getNodes()) {
                IConcept concept = n.getConcept();
                if (!"cDate".equals(concept.getName()) || Boolean.TRUE != n.getProperty("__isDateHierarchy")) continue;
                dateCat = n;
                break;
            }
            if (null == dateCat) continue;
            IDataItem dataItem = MetadataHelper.getDefaultDataItem(dateCat);
            String tableName = RelationalDataItems.getTableName((IDataItem)dataItem);
            if (!tables.contains(tableName)) {
                tables.add(tableName);
            }
            String calTableIdent = (String)dateCat.getProperty("__calendarTable");
            String calDateColumnIdent = (String)dateCat.getProperty("__calendarDateColumn");
            assert (null != calTableIdent);
            assert (null != calDateColumnIdent);
            if (!tables.contains(calTableIdent)) {
                tables.add(calTableIdent);
            }
            if (null == dataItem) continue;
            IDataType dtype = dataItem.getDataType();
            boolean needsCasting = false;
            if (!dtype.isTemporal()) {
                throw new QLSRuntimeException(QLSMessageKeys.EXE_WrongResultType, "temporal", (Object)dtype.toString());
            }
            if (dtype.getBaseType() != BaseDataType.DATE) {
                needsCasting = true;
            }
            SQLComparison vExpr = (SQLComparison)nodeFactory.createNode(3005);
            vExpr.setSubType(SQLComparison.SubType.EQUAL);
            SQLColumn lColumn = SQLUtil.createSQLColumn(nodeFactory, calTableIdent, calDateColumnIdent);
            SQLColumn rColumn = SQLUtil.createSQLColumn(nodeFactory, dataItem);
            vExpr.addChild(lColumn);
            if (needsCasting) {
                SQLDataType dataType = (SQLDataType)nodeFactory.createNode(3006);
                dataType.setDataType((IDataType)new DateType());
                SQLCast cast = (SQLCast)nodeFactory.createNode(3003);
                cast.addChild(rColumn);
                cast.addChild(dataType);
                vExpr.addChild(cast);
            } else {
                vExpr.addChild(rColumn);
            }
            predicates.add(vExpr);
        }
        ISQLQueryNode productNode = (ISQLQueryNode)nodeFactory.createNode(3021);
        for (i = 0; i < tables.size(); ++i) {
            SQLRelation relation = (SQLRelation)nodeFactory.createNode(3024);
            relation.setTableName((String)tables.get(i));
            SQLRangeVar rangeVar = (SQLRangeVar)nodeFactory.createNode(3023);
            rangeVar.setName("T" + i);
            rangeVar.addChild(relation);
            productNode.addChild(rangeVar);
        }
        node.addChild((IXQEQueryNode)productNode);
        if (containers.size() > 1) {
            for (i = 0; i < containers.size(); ++i) {
                List list1 = ((IDataContainer)containers.get(i)).getDataItems();
                for (int j = i + 1; j < containers.size(); ++j) {
                    List list2 = ((IDataContainer)containers.get(j)).getDataItems();
                    block6: for (IDataItem dataItem : list1) {
                        for (IDataItem dataItem2 : list2) {
                            if (!dataItem.getName().equals(dataItem2.getName())) continue;
                            SQLColumn lColumn = SQLUtil.createSQLColumn(nodeFactory, dataItem);
                            SQLColumn rColumn = SQLUtil.createSQLColumn(nodeFactory, dataItem2);
                            SQLComparison vExpr = (SQLComparison)nodeFactory.createNode(3005);
                            vExpr.setSubType(SQLComparison.SubType.EQUAL);
                            vExpr.addChild(lColumn);
                            vExpr.addChild(rColumn);
                            predicates.add(vExpr);
                            continue block6;
                        }
                    }
                }
            }
        }
        if (predicates.size() > 0) {
            IXQEQueryNode predicate = null;
            for (int i2 = 0; i2 < predicates.size(); ++i2) {
                if (null == predicate) {
                    predicate = (IXQEQueryNode)predicates.get(i2);
                    continue;
                }
                SQLLogical logical = (SQLLogical)nodeFactory.createNode(3019);
                logical.setSubType(SQLLogical.SubType.AND);
                logical.addChild(predicate);
                logical.addChild((IXQEQueryNode)predicates.get(i2));
                predicate = logical;
            }
            ISQLQueryNode filter = (ISQLQueryNode)nodeFactory.createNode(3009);
            filter.addChild(predicate);
            node.addChild((IXQEQueryNode)filter);
        }
        selectNode.setTables(tables);
        selectNode.setPropertyValue(SQLPRODUCT_BUILT, Boolean.TRUE);
    }
}

