/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.sql;

import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.query.queryspec.actions.ISortKey;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.ISortByAttribute;
import com.ibm.cognos.aurora.api.query.queryspec.expression.ICategoryMetricNode;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.core.model.MetadataHelper;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.ISQLQueryNode;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLColumn;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLRangeVar;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLSelect;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLSortKey;
import com.ibm.cognos.aurora.qls.query.planner.rules.sql.SQLQueryRule;
import com.ibm.cognos.aurora.qls.query.planner.rules.sql.util.SQLUtil;
import com.ibm.cognos.aurora.qls.query.queryspec.ExpressionAttributeValue;
import com.ibm.cognos.aurora.qls.query.queryspec.SortByData;
import com.ibm.cognos.aurora.qls.query.queryspec.SortKey;
import java.util.List;
import java.util.Map;

public class BuildSQLSort
extends SQLQueryRule {
    public BuildSQLSort() {
        this.mName = "Construct a SQLSort node.";
        this.mPassNumbers = new int[]{4};
        this.mTypes = new int[]{3026};
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        if (!BuildSQLSort.hasRelationalDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with a relational data source.", trace);
            return false;
        }
        boolean bl = status = node.getChild(0).getType() != 2 && node.getChild(0).getType() != 3027 && (node.getDescendantsOfType(15, false).length > 0 || node.getDescendantsOfType(21, false).length > 0 || node.getDescendantsOfType(23, false).length > 0);
        if (status) {
            this.traceNodeCondition(true, "SQLSort node needs to be constructed.", trace);
        } else {
            this.traceNodeCondition(false, "SQLSort node has already been constructed.", trace);
        }
        return status;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLSelect selectNode = (SQLSelect)node;
        Map<IDataItem, Integer> mapping = selectNode.getColumnMapping();
        List<INode> extraNodes = selectNode.getExtraNodes();
        SQLRangeVar rangeVar = null;
        if (extraNodes.size() > 0) {
            rangeVar = (SQLRangeVar)selectNode.getDescendantsOfType(3023, false, 3021)[0];
        }
        List sorts = node.getDescendantsOfTypeOrdered(15, false);
        List sortByData = node.getDescendantsOfTypeOrdered(21, false);
        List sortByAttribute = node.getDescendantsOfTypeOrdered(23, false);
        if (sorts.size() > 0 || sortByData.size() > 0 || sortByAttribute.size() > 0) {
            ISQLQueryNode sortNode = (ISQLQueryNode)nodeFactory.createNode(3027);
            ISQLQueryNode sortKeyList = (ISQLQueryNode)nodeFactory.createNode(3029);
            String tableName = null;
            if (null != rangeVar) {
                tableName = rangeVar.getName();
            }
            for (IXQEQueryNode sortItem : sortByData) {
                SortByData sbd = (SortByData)sortItem;
                IXQEQueryNode[] sortChildren = sbd.getChildren();
                ISortKey sKey = (ISortKey)sortChildren[0];
                ExpressionAttributeValue av = (ExpressionAttributeValue)sortChildren[1];
                this.createSortKeyForAttribute(nodeFactory, mapping, sortKeyList, tableName, sKey, av.getAttribute());
                sortItem.extract();
            }
            for (IXQEQueryNode sortItem : sortByAttribute) {
                ISortByAttribute sba = (ISortByAttribute)sortItem;
                ISortKey sKey = sba.getSortKey();
                this.createSortKeyForAttribute(nodeFactory, mapping, sortKeyList, tableName, sKey, sba.getAttribute());
                sortItem.detach();
            }
            for (IXQEQueryNode sort : sorts) {
                IXQEQueryNode[] keys;
                for (IXQEQueryNode key : keys = sort.getChildren()) {
                    SortKey sKey = (SortKey)key;
                    ICategoryMetricNode cmNode = (ICategoryMetricNode)sKey.getChild(0).extract();
                    this.createSortKeyForAttribute(nodeFactory, mapping, sortKeyList, tableName, sKey, cmNode.getNode());
                    sKey.extract();
                }
                sort.extract();
            }
            selectNode.getChild(0).insertParent((IXQEQueryNode)sortNode);
            sortNode.addChild(sortKeyList);
        }
    }

    private void createSortKeyForAttribute(XQENodeFactory nodeFactory, Map<IDataItem, Integer> mapping, ISQLQueryNode sortKeyList, String tableName, ISortKey sKey, INode attribute) {
        IDataItem dataItem = MetadataHelper.getDefaultDataItem((INode)attribute);
        int columnNo = mapping.get(dataItem);
        SQLColumn column = SQLUtil.createSQLColumn(nodeFactory, tableName, String.format("C%d", columnNo));
        SQLSortKey sortKey = (SQLSortKey)nodeFactory.createNode(3028);
        sortKey.addChild(column);
        sortKey.setAscending(sKey.isAscending());
        sortKeyList.addChild(sortKey);
    }
}

