/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.sql;

import com.ibm.cognos.aurora.api.query.queryspec.expression.IQuerySpecAttributeValue;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLLiteral;
import com.ibm.cognos.aurora.qls.query.planner.rules.sql.SQLQueryRule;

public class ConvertAttributeValueToSQLLiteral
extends SQLQueryRule {
    public ConvertAttributeValueToSQLLiteral() {
        this.mName = "Convert an attribute value in a value list to an SQLLiteral node.";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{9};
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!ConvertAttributeValueToSQLLiteral.hasRelationalDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with a relational data source.", trace);
            return false;
        }
        if (node.getParent().getType() == 3031) {
            this.traceNodeCondition(true, "The attribute value needs to be converted to SQLLiteral.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The attribute value is not part of a value list.", trace);
        return false;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLLiteral literal = (SQLLiteral)nodeFactory.createNode(3018);
        literal.setValue(((IQuerySpecAttributeValue)node).getValue());
        node.exchange((IXQEQueryNode)literal, true);
    }
}

