/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.sql;

import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.query.queryspec.expression.ESetFunction;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.rules.AbstractRule;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.core.model.MetadataHelper;
import com.ibm.cognos.aurora.core.model.RelationalDataItems;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLColumn;
import com.ibm.cognos.aurora.qls.query.planner.rules.sql.SQLQueryRule;
import com.ibm.cognos.aurora.qls.query.queryspec.AxisNodeMap;
import com.ibm.cognos.aurora.qls.query.queryspec.AxisSpecification;
import com.ibm.cognos.aurora.qls.query.queryspec.SelectionActionCategory;
import com.ibm.cognos.aurora.qls.query.queryspec.SetFunction;

public class ConvertCategoryToSQLColumn
extends SQLQueryRule {
    public ConvertCategoryToSQLColumn() {
        this.mName = "Convert a category to an SQLColumn node.";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{6};
        this.mMode = AbstractRule.Mode.TOP_DOWN;
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        if (!ConvertCategoryToSQLColumn.hasRelationalDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with a relational data source.", trace);
            return false;
        }
        IXQEQueryNode parent = node.getParent();
        boolean bl = status = parent.getType() != 14 || ((SetFunction)parent).getFunctionType() != ESetFunction.DRILLUP;
        if (status) {
            this.traceNodeCondition(true, "ICategoryMetricNode needs to be converted to an SQL column.", trace);
        } else {
            this.traceNodeCondition(false, "ICategoryMetricNode does not need to be converted to an SQL column.", trace);
        }
        return status;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SelectionActionCategory action = (SelectionActionCategory)node;
        INode category = action.getCategory();
        IDataItem dataItem = MetadataHelper.getDefaultDataItem((INode)category);
        AxisNodeMap map = new AxisNodeMap(category);
        AxisSpecification axisSpec = (AxisSpecification)node.getAncestorOfType(2);
        axisSpec.getNodeList().add(map);
        SQLColumn column = (SQLColumn)nodeFactory.createNode(3004);
        column.setTableName(RelationalDataItems.getTableName((IDataItem)dataItem));
        column.setName(RelationalDataItems.getColumnName((IDataItem)dataItem));
        column.setDataItem(dataItem);
        column.setAxisNodeMap(map);
        column.setHierarchy(action.getHierarchy());
        column.setNode(category);
        node.exchange((IXQEQueryNode)column, true);
    }
}

