/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.sql;

import com.ibm.cognos.aurora.api.query.queryspec.expression.ILiteralNode;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLLiteral;
import com.ibm.cognos.aurora.qls.query.planner.rules.sql.SQLQueryRule;

public class ConvertLiteralToSQLLiteral
extends SQLQueryRule {
    public ConvertLiteralToSQLLiteral() {
        this.mName = "Convert a literal node to an SQLLiteral node.";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{11};
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!ConvertLiteralToSQLLiteral.hasRelationalDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with a relational data source.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Literal needs to be converted to SQLLiteral.", trace);
        return true;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLLiteral literal = (SQLLiteral)nodeFactory.createNode(3018);
        literal.setValue(((ILiteralNode)node).getValue());
        node.exchange((IXQEQueryNode)literal, true);
    }
}

