/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.sql;

import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.INodesSelection;
import com.ibm.cognos.aurora.api.query.queryspec.expression.ESetFunction;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.rules.AbstractRule;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.core.model.MetadataHelper;
import com.ibm.cognos.aurora.core.model.RelationalDataItems;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLColumn;
import com.ibm.cognos.aurora.qls.query.planner.rules.sql.SQLQueryRule;
import com.ibm.cognos.aurora.qls.query.queryspec.AxisNodeMap;
import com.ibm.cognos.aurora.qls.query.queryspec.AxisSpecification;
import com.ibm.cognos.aurora.qls.query.queryspec.SetFunction;

public class ConvertNodesToSQLColumn
extends SQLQueryRule {
    public ConvertNodesToSQLColumn() {
        this.mName = "Convert a category or attribute to an SQLColumn node.";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{22};
        this.mMode = AbstractRule.Mode.TOP_DOWN;
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        if (!ConvertNodesToSQLColumn.hasRelationalDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with a relational data source.", trace);
            return false;
        }
        IXQEQueryNode parent = node.getParent();
        boolean bl = status = parent.getType() != 14 || ((SetFunction)parent).getFunctionType() != ESetFunction.DRILLUP;
        if (status) {
            this.traceNodeCondition(true, "INodesSelection needs to be converted to an SQL column.", trace);
        } else {
            this.traceNodeCondition(false, "INodesSelection does not need to be converted to an SQL column.", trace);
        }
        return status;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        INodesSelection action = (INodesSelection)node;
        INode[] metadataNodes = action.getNodes();
        if (metadataNodes.length > 1) {
            throw new IllegalStateException("The relational planner and only handle one category/attribute per selection.");
        }
        IDataItem dataItem = metadataNodes[0].isCategory() ? MetadataHelper.getDefaultDataItem((INode)metadataNodes[0]) : metadataNodes[0].getDataItem();
        AxisNodeMap map = new AxisNodeMap(metadataNodes[0]);
        AxisSpecification axisSpec = (AxisSpecification)node.getAncestorOfType(2);
        axisSpec.getNodeList().add(map);
        SQLColumn column = (SQLColumn)nodeFactory.createNode(3004);
        column.setTableName(RelationalDataItems.getTableName((IDataItem)dataItem));
        column.setName(RelationalDataItems.getColumnName((IDataItem)dataItem));
        column.setDataItem(dataItem);
        column.setAxisNodeMap(map);
        column.setNode(metadataNodes[0]);
        node.exchange((IXQEQueryNode)column, true);
    }
}

