/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.sql;

import com.ibm.cognos.aurora.api.query.queryspec.expression.IScalarFunction;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLFunction;
import com.ibm.cognos.aurora.qls.query.planner.rules.sql.SQLQueryRule;

public class ConvertScalarFunctionToSQLFunction
extends SQLQueryRule {
    public ConvertScalarFunctionToSQLFunction() {
        this.mName = "Convert a scalar function node to an SQLFunction node.";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{13};
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!ConvertScalarFunctionToSQLFunction.hasRelationalDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with a relational data source.", trace);
            return false;
        }
        this.traceNodeCondition(true, "ScalarFunction needs to be converted to SQLFunction.", trace);
        return true;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLFunction fNode = (SQLFunction)nodeFactory.createNode(3010);
        fNode.setSubType(((IScalarFunction)node).getFunctionType());
        node.exchange((IXQEQueryNode)fNode, true);
    }
}

