/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.sql;

import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.query.planner.rules.sql.SQLQueryRule;

public class ConvertValueListToSQLValueList
extends SQLQueryRule {
    public ConvertValueListToSQLValueList() {
        this.mName = "Convert a value list node to an SQLValueList node.";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{17};
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!ConvertValueListToSQLValueList.hasRelationalDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with a relational data source.", trace);
            return false;
        }
        this.traceNodeCondition(true, "ValueList needs to be converted to SQLValueList.", trace);
        return true;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode vList = nodeFactory.createNode(3031);
        node.exchange(vList, true);
    }
}

