/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.sql;

import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.model.physical.rel.IRelModel;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLSelect;
import com.ibm.cognos.aurora.qls.query.planner.rules.sql.SQLQueryRule;
import java.util.ArrayList;

public class ConvertViewToSQLSelect
extends SQLQueryRule {
    public ConvertViewToSQLSelect() {
        this.mName = "Convert a QuerySpec View to an SQL Query.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{1};
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!ConvertViewToSQLSelect.hasRelationalDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with a relational data source.", trace);
            return false;
        }
        if (node.getType() == 1) {
            this.traceNodeCondition(true, "ViewSpecification needs to be converted to a SQLSelect.", trace);
            return true;
        }
        this.traceNodeCondition(false, "Node is not of type ViewSpecification", trace);
        return false;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IRelModel relModel = (IRelModel)ConvertViewToSQLSelect.getPhysicalModel(node);
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLSelect qNode = (SQLSelect)nodeFactory.createNode(3026, node);
        qNode.setRelModel(relModel);
        qNode.setExtraNodes(new ArrayList<INode>());
        node.exchange((IXQEQueryNode)qNode, true);
    }
}

