/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.sql;

import com.ibm.cognos.aurora.api.query.queryspec.expression.ESetFunction;
import com.ibm.cognos.aurora.api.query.queryspec.expression.ISetFunction;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.query.planner.rules.sql.SQLQueryRule;
import com.ibm.cognos.aurora.qls.query.queryspec.Sort;
import com.ibm.cognos.aurora.qls.query.queryspec.SortKey;

public class PreprocessCount
extends SQLQueryRule {
    public PreprocessCount() {
        this.mName = "Preprocess count set functions.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{14};
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        if (!PreprocessCount.hasRelationalDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with a relational data source.", trace);
            return false;
        }
        ESetFunction fType = ((ISetFunction)node).getFunctionType();
        boolean bl = status = node.getAncestorOfType(3026) != null && (fType == ESetFunction.TOPCOUNT || fType == ESetFunction.BOTTOMCOUNT) && node.getNumberChildren() == 2;
        if (status) {
            this.traceNodeCondition(true, "Preprocessing required for count set functions.", trace);
        } else {
            this.traceNodeCondition(false, "Preprocessing not required for count set functions.", trace);
        }
        return status;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode setSpec = node.getAncestorOfType(3);
        SortKey sortKey = (SortKey)nodeFactory.createNode(16);
        sortKey.addChild(node.getChild(1).detach());
        sortKey.setAscending(((ISetFunction)node).getFunctionType() == ESetFunction.BOTTOMCOUNT);
        Sort sortNode = (Sort)nodeFactory.createNode(15);
        sortNode.addChild((IXQEQueryNode)sortKey);
        setSpec.addChild((IXQEQueryNode)sortNode);
    }
}

