/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.sql;

import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.query.queryspec.ISelectionSpecification;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.ICategorySelection;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.INodesSelection;
import com.ibm.cognos.aurora.api.query.queryspec.expression.EOperator;
import com.ibm.cognos.aurora.api.query.queryspec.expression.ESetFunction;
import com.ibm.cognos.aurora.api.query.queryspec.expression.ISetFunction;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.core.model.NavigationHelper;
import com.ibm.cognos.aurora.qls.query.planner.rules.sql.SQLQueryRule;
import com.ibm.cognos.aurora.qls.query.queryspec.CategoryMetricNode;
import com.ibm.cognos.aurora.qls.query.queryspec.OperatorNode;
import com.ibm.cognos.aurora.qls.query.queryspec.SelectionActionCategory;
import com.ibm.cognos.aurora.qls.query.queryspec.SelectionActionNode;
import com.ibm.cognos.aurora.qls.query.queryspec.SelectionSpecification;
import java.util.List;

public class PreprocessDrillDown
extends SQLQueryRule {
    public PreprocessDrillDown() {
        this.mName = "Preprocess DRILLDOWN set function.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{14};
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        if (!PreprocessDrillDown.hasRelationalDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with a relational data source.", trace);
            return false;
        }
        ISelectionSpecification selection = (ISelectionSpecification)node.getAncestorOfType(4);
        List actions = selection.getSelectionActions();
        int index = actions.indexOf(node);
        boolean bl = status = node.getAncestorOfType(3026) != null && ((ISetFunction)node).getFunctionType() == ESetFunction.DRILLDOWN && (actions.get(index - 1) instanceof ICategorySelection || actions.get(index - 1) instanceof INodesSelection);
        if (status) {
            this.traceNodeCondition(true, "Preprocessing required for DRILLDOWN operation.", trace);
        } else {
            this.traceNodeCondition(false, "Preprocessing not required for DRILLDOWN operation.", trace);
        }
        return status;
    }

    INode determineCurrentSelection(IXQEQueryNode node, ISelectionSpecification selection, XQENodeFactory nodeFactory) {
        List actions = selection.getSelectionActions();
        int index = actions.indexOf(node);
        SelectionActionNode aSelection = (SelectionActionNode)((SelectionActionNode)((Object)actions.get(index - 1))).detach();
        INode category = null;
        if (aSelection instanceof SelectionActionCategory) {
            category = ((SelectionActionCategory)aSelection).getCategory();
        } else if (aSelection instanceof INodesSelection) {
            INode[] selectedNodes = ((INodesSelection)aSelection).getNodes();
            category = selectedNodes[0];
        }
        if (category.isAttribute()) {
            category = NavigationHelper.getCategoryFromAttribute((INode)category);
        }
        List nodes = NavigationHelper.getPartNodes((INode)category);
        SelectionActionCategory action = (SelectionActionCategory)nodeFactory.createNode(6);
        action.setCategory((INode)nodes.get(0));
        List hierarchy = NavigationHelper.getHierarchy((INode)category);
        action.setHierarchy(hierarchy);
        SelectionSpecification selectionAction = (SelectionSpecification)selection;
        selectionAction.addChild((IXQEQueryNode)action, index - 1);
        selectionAction.detachChild(index);
        return category;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SelectionSpecification selection = (SelectionSpecification)node.getAncestorOfType(4);
        INode category = this.determineCurrentSelection(node, selection, nodeFactory);
        IXQEQueryNode[] attributes = node.getChildren();
        CategoryMetricNode cmNode = (CategoryMetricNode)nodeFactory.createNode(8);
        cmNode.setNode(category);
        OperatorNode predicate = (OperatorNode)nodeFactory.createNode(12);
        predicate.addChild((IXQEQueryNode)cmNode);
        if (attributes.length == 1) {
            predicate.setOperatorType(EOperator.EQUALS);
            predicate.addChild(attributes[0].detach());
        } else {
            IXQEQueryNode vList = nodeFactory.createNode(17);
            for (IXQEQueryNode attribute : attributes) {
                vList.addChild(attribute.detach());
            }
            predicate.setOperatorType(EOperator.IN);
            predicate.addChild(vList);
        }
        IXQEQueryNode filter = nodeFactory.createNode(10);
        filter.addChild((IXQEQueryNode)predicate);
        selection.addChild(filter);
        node.extract();
    }
}

