/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.sql;

import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.query.queryspec.ISelectionSpecification;
import com.ibm.cognos.aurora.api.query.queryspec.actions.ISelectionAction;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.ICategorySelection;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.INodesSelection;
import com.ibm.cognos.aurora.api.query.queryspec.expression.ESetFunction;
import com.ibm.cognos.aurora.api.query.queryspec.expression.ISetFunction;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.core.model.NavigationHelper;
import com.ibm.cognos.aurora.qls.query.planner.rules.sql.SQLQueryRule;
import com.ibm.cognos.aurora.qls.query.queryspec.SelectionActionCategory;
import com.ibm.cognos.aurora.qls.query.queryspec.SelectionActionNode;
import com.ibm.cognos.aurora.qls.query.queryspec.SelectionSpecification;
import java.util.List;

public class PreprocessDrillUp
extends SQLQueryRule {
    public PreprocessDrillUp() {
        this.mName = "Preprocess DRILLUP set function.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{14};
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        if (!PreprocessDrillUp.hasRelationalDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with a relational data source.", trace);
            return false;
        }
        ISelectionSpecification selection = (ISelectionSpecification)node.getAncestorOfType(4);
        List actions = selection.getSelectionActions();
        int index = actions.indexOf(node);
        boolean bl = status = node.getAncestorOfType(3026) != null && ((ISetFunction)node).getFunctionType() == ESetFunction.DRILLUP && (actions.get(index - 1) instanceof ICategorySelection || actions.get(index - 1) instanceof INodesSelection) && node.getChild(0).getType() == 11;
        if (status) {
            this.traceNodeCondition(true, "Preprocessing required for DRILLUP operation.", trace);
        } else {
            this.traceNodeCondition(false, "Preprocessing not required for DRILLUP operation.", trace);
        }
        return status;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        SelectionActionNode nextAction;
        INode[] selectedNodes;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SelectionSpecification selection = (SelectionSpecification)node.getAncestorOfType(4);
        List<ISelectionAction> actions = selection.getSelectionActions();
        int index = actions.indexOf(node);
        SelectionActionNode aSelection = (SelectionActionNode)actions.get(index - 1);
        INode category = null;
        List<INode> hierarchy = null;
        if (aSelection instanceof SelectionActionCategory) {
            SelectionActionCategory categorySelection = (SelectionActionCategory)aSelection;
            category = categorySelection.getCategory();
            hierarchy = categorySelection.getHierarchy();
        } else if (aSelection instanceof INodesSelection && (category = (selectedNodes = ((INodesSelection)aSelection).getNodes())[0]).isAttribute()) {
            category = NavigationHelper.getCategoryFromAttribute((INode)category);
        }
        if (hierarchy == null) {
            hierarchy = NavigationHelper.getHierarchy((INode)category);
        }
        int hierarchyIdx = hierarchy.indexOf(category);
        INode parent = hierarchy.get(hierarchyIdx - 1);
        SelectionActionCategory action = (SelectionActionCategory)nodeFactory.createNode(6);
        action.setCategory(parent);
        action.setHierarchy(hierarchy);
        selection.addChild((IXQEQueryNode)action, index - 1);
        IXQEQueryNode[] filters = selection.getChildrenOfTypeOrdered(10);
        if (filters.length > 0) {
            selection.detachChild(filters[filters.length - 1]);
        }
        boolean removeNode = false;
        if (index < actions.size() - 1 && ((nextAction = (SelectionActionNode)actions.get(index + 1)).getType() == 14 && ((ISetFunction)nextAction).getFunctionType() == ESetFunction.DRILLUP || ((ISetFunction)nextAction).getFunctionType() == ESetFunction.DRILLDOWN)) {
            removeNode = true;
        }
        if (hierarchyIdx - 1 > 0 && !removeNode) {
            aSelection.move(node, 0);
        } else {
            aSelection.extract();
            node.getChild(0).extract();
            node.extract();
        }
    }
}

