/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.sql;

import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.query.queryspec.ISelectionSpecification;
import com.ibm.cognos.aurora.api.query.queryspec.actions.ISelectionAction;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.ICategorySelection;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.INodesSelection;
import com.ibm.cognos.aurora.api.query.queryspec.expression.ESetFunction;
import com.ibm.cognos.aurora.api.query.queryspec.expression.ISetFunction;
import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.core.model.DateHierarchyHelper;
import com.ibm.cognos.aurora.core.model.NavigationHelper;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLSelect;
import com.ibm.cognos.aurora.qls.query.planner.rules.sql.SQLQueryRule;
import com.ibm.cognos.aurora.qls.query.queryspec.CategoryMetricNode;
import java.util.List;

public class PreprocessLastPeriods
extends SQLQueryRule {
    public PreprocessLastPeriods() {
        this.mName = "Preprocess LASTPERIODS set function.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{14};
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        if (!PreprocessLastPeriods.hasRelationalDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with a relational data source.", trace);
            return false;
        }
        boolean bl = status = node.getAncestorOfType(3026) != null && ((ISetFunction)node).getFunctionType() == ESetFunction.LASTPERIODS && node.getNumberChildren() == 1;
        if (status) {
            this.traceNodeCondition(true, "Preprocessing required for LASTPERIODS set function.", trace);
        } else {
            this.traceNodeCondition(false, "Preprocessing not required for LASTPERIODS set function.", trace);
        }
        return status;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        ISelectionSpecification selection = (ISelectionSpecification)node.getAncestorOfType(4);
        List actions = selection.getSelectionActions();
        ISelectionAction selectionAction = (ISelectionAction)actions.get(0);
        INode category = null;
        category = selectionAction instanceof ICategorySelection ? ((ICategorySelection)actions.get(0)).getCategory() : ((INodesSelection)actions.get(0)).getNodes()[0];
        IConcept concept = category.getConcept();
        DateHierarchyHelper dateHelper = DateHierarchyHelper.forTemporalCategory((INode)category);
        CategoryMetricNode cmNode = (CategoryMetricNode)nodeFactory.createNode(8);
        cmNode.setNode(category);
        node.addChild((IXQEQueryNode)cmNode);
        String conceptName = concept.getName();
        if (conceptName.equals("cQuarter") || conceptName.equals("cMonth")) {
            SQLSelect select = (SQLSelect)node.getAncestorOfType(3026);
            List attributeList = NavigationHelper.getAttributeNodes((INode)category);
            INode quarterAttr = null;
            INode monthAttr = null;
            if (conceptName.equals("cQuarter")) {
                quarterAttr = (INode)attributeList.get(0);
            } else {
                quarterAttr = dateHelper.getQuarterIdentifier();
                monthAttr = (INode)attributeList.get(0);
            }
            select.addExtraNode(dateHelper.getYearIdentifier());
            select.addExtraNode(quarterAttr);
            if (monthAttr != null) {
                select.addExtraNode(monthAttr);
            }
        }
    }
}

