/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider.connection;

import com.ibm.cognos.aurora.api.query.provider.connection.IConnectionPoolManager;
import com.ibm.cognos.aurora.api.query.provider.connection.IProviderConnectionPool;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ConnectionPoolManager
implements IConnectionPoolManager {
    private static final long MAINTENANCE_PERIOD = 5000L;
    private final ConcurrentLinkedQueue<IProviderConnectionPool> mRegisteredPools = new ConcurrentLinkedQueue();
    private Timer mTimer = new Timer("ConnectionPoolTimer", true);
    private static final ILogger logger = LoggerManager.getLogger((String)"ATHENA.core.qls.connection.pool");

    public ConnectionPoolManager() {
        this.mTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                ConnectionPoolManager.this.runMaintenance();
            }
        }, 5000L, 5000L);
    }

    private void runMaintenance() {
        for (IProviderConnectionPool pool : this.mRegisteredPools) {
            try {
                pool.cleanup();
            }
            catch (Throwable ex) {
                logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::runMaintenance()", ex);
            }
        }
    }

    public void registerPool(IProviderConnectionPool pool) {
        if (logger.isInfoEnabled()) {
            String msg = String.format("Registered Connection Pool (%s)", pool.toString());
            logger.info(msg, this.getClass().getName() + "::registerPool()");
        }
        this.mRegisteredPools.add(pool);
    }

    public void unregisterPool(IProviderConnectionPool pool) {
        if (logger.isInfoEnabled()) {
            String msg = String.format("Unregistered Connection Pool (%s)", pool.toString());
            logger.info(msg, this.getClass().getName() + "::unregisterPool()");
        }
        this.mRegisteredPools.remove(pool);
    }

    public void shutdown() {
        if (logger.isInfoEnabled()) {
            logger.info("Shutting down Connection Pool Manager", this.getClass().getName() + "::shutdown()");
        }
        this.mTimer.cancel();
        for (IProviderConnectionPool pool : this.mRegisteredPools) {
            if (logger.isWarnEnabled()) {
                String msg = String.format("Connection Pool (%s) was not unregistered and will be shutdown", pool.toString());
                logger.warn(msg, this.getClass().getName() + "::shutdown()");
            }
            try {
                pool.shutdown();
            }
            catch (Throwable ex) {
                logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::shutdown()", ex);
            }
        }
        this.mRegisteredPools.clear();
    }
}

