/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider.connection;

import com.ibm.cognos.aurora.api.query.provider.connection.IExpirationPolicy;
import com.ibm.cognos.aurora.api.query.provider.connection.IProviderConnection;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;

public class SimpleExpirationPolicy
implements IExpirationPolicy {
    private final long mMaxIdleTime;
    private static final ILogger logger = LoggerManager.getLogger((String)"ATHENA.core.qls.connection");

    public SimpleExpirationPolicy(long maxIdleTime) {
        this.mMaxIdleTime = maxIdleTime;
    }

    public boolean isExpired(IProviderConnection connection) {
        boolean expired;
        long idleTime = connection.idleTime();
        boolean bl = expired = idleTime > this.mMaxIdleTime;
        if (expired && logger.isInfoEnabled()) {
            String msg = String.format("Connection (%s) was expired, because it was idle for too long (%s ms)", connection.toString(), idleTime);
            logger.info(msg, this.getClass().getName() + "::isExpired()");
        }
        return expired;
    }
}

