/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider.relational;

import com.ibm.cognos.aurora.api.model.IConnectionSpec;
import com.ibm.cognos.aurora.api.query.provider.IDataProvider;
import com.ibm.cognos.aurora.qls.exception.QLSMessageKeys;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.query.provider.connection.AbstractProviderConnection;
import java.sql.Connection;
import java.sql.SQLException;

public abstract class JDBCProviderConnection
extends AbstractProviderConnection {
    public static final String JDBC_CONNECTION_STRING = "jdbcConnectionString";
    public static final String DB_NAME = "dbName";
    private final Connection mConn;

    public JDBCProviderConnection(IDataProvider provider, IConnectionSpec connSpec, Connection conn) {
        super(provider, connSpec);
        this.mConn = conn;
    }

    public Connection getJDBCConnection() {
        return this.mConn;
    }

    @Override
    protected boolean validateImpl() {
        try {
            return !this.mConn.isClosed();
        }
        catch (SQLException ex) {
            return false;
        }
    }

    @Override
    protected void closeImpl() {
        try {
            this.mConn.close();
        }
        catch (SQLException ex) {
            throw new QLSRuntimeException(QLSMessageKeys.PRV_JDBCError, ex, (Object)ex.getErrorCode(), (Object)ex.getSQLState(), (Object)ex.getMessage());
        }
    }
}

