/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider.relational.metadata;

import com.ibm.cognos.aurora.api.model.datatype.DataTypes;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.IntegerValue;
import com.ibm.cognos.aurora.api.model.value.StringValue;
import com.ibm.cognos.aurora.api.query.provider.EMetadataRecordType;
import com.ibm.cognos.aurora.api.query.provider.tabular.IColumnRecord;
import com.ibm.cognos.aurora.qls.query.provider.FieldIndex;
import com.ibm.cognos.aurora.qls.query.provider.MetadataRecord;

public class ColumnRecord
extends MetadataRecord
implements IColumnRecord {
    public ColumnRecord() {
    }

    public ColumnRecord(FieldIndex index) {
        super(index);
    }

    public EMetadataRecordType getType() {
        return EMetadataRecordType.REL_COLUMN;
    }

    public String getCatalogName() {
        IValue v = this.getFieldValue("TABLE_CAT");
        if (null == v) {
            return null;
        }
        return v.stringValue();
    }

    public void setCatalogName(String catalogName) {
        StringValue v = new StringValue();
        v.set(catalogName);
        this.setFieldValue("TABLE_CAT", (IValue)v);
    }

    public String getSchemaName() {
        IValue v = this.getFieldValue("TABLE_SCHEM");
        if (null == v) {
            return null;
        }
        return v.stringValue();
    }

    public void setSchemaName(String schemaName) {
        StringValue v = new StringValue();
        v.set(schemaName);
        this.setFieldValue("TABLE_SCHEM", (IValue)v);
    }

    public String getTableName() {
        IValue v = this.getFieldValue("TABLE_NAME");
        if (null == v) {
            return null;
        }
        return v.stringValue();
    }

    public void setTableName(String tableName) {
        StringValue v = new StringValue();
        v.set(tableName);
        this.setFieldValue("TABLE_NAME", (IValue)v);
    }

    public String getColumnName() {
        IValue v = this.getFieldValue("COLUMN_NAME");
        if (null == v) {
            return null;
        }
        return v.stringValue();
    }

    public void setColumnName(String columnName) {
        StringValue v = new StringValue();
        v.set(columnName);
        this.setFieldValue("COLUMN_NAME", (IValue)v);
    }

    public IDataType getDataType() {
        switch (this.getSQLDataType()) {
            case 1: 
            case 12: {
                return DataTypes.getStringType((int)this.getColumnSize());
            }
            case 2005: {
                return DataTypes.getStringType((int)Integer.MAX_VALUE);
            }
            case 3: {
                return DataTypes.getDecimalType((int)this.getColumnSize(), (int)this.getDecimalDigits());
            }
            case 8: {
                return DataTypes.getDoubleType();
            }
            case 6: 
            case 7: {
                return DataTypes.getFloatType();
            }
            case -5: {
                return DataTypes.getLongType();
            }
            case -6: 
            case 4: 
            case 5: {
                return DataTypes.getIntegerType();
            }
            case 91: {
                return DataTypes.getDateType();
            }
            case 93: {
                return DataTypes.getTimestampType();
            }
            case 16: {
                return DataTypes.getBooleanType();
            }
            case 92: {
                return DataTypes.getStringType((int)20);
            }
        }
        return DataTypes.getUnknownType();
    }

    public int getSQLDataType() {
        IValue v = this.getFieldValue("DATA_TYPE");
        if (null == v) {
            return -1;
        }
        return v.intValue();
    }

    public void setSQLDataType(int sqlType) {
        IntegerValue v = new IntegerValue();
        v.set(sqlType);
        this.setFieldValue("DATA_TYPE", (IValue)v);
    }

    public String getTypeName() {
        IValue v = this.getFieldValue("TYPE_NAME");
        if (null == v) {
            return null;
        }
        return v.stringValue();
    }

    public void setTypeName(String typeName) {
        StringValue v = new StringValue();
        v.set(typeName);
        this.setFieldValue("TYPE_NAME", (IValue)v);
    }

    public int getColumnSize() {
        IValue v = this.getFieldValue("COLUMN_SIZE");
        if (null == v) {
            return 0;
        }
        return v.intValue();
    }

    public void setColumnSize(int colSize) {
        IntegerValue v = new IntegerValue();
        v.set(colSize);
        this.setFieldValue("COLUMN_SIZE", (IValue)v);
    }

    public int getDecimalDigits() {
        IValue v = this.getFieldValue("DECIMAL_DIGITS");
        if (null == v) {
            return 0;
        }
        return v.intValue();
    }

    public void setDecimalDigits(int digits) {
        IntegerValue v = new IntegerValue();
        v.set(digits);
        this.setFieldValue("DECIMAL_DIGITS", (IValue)v);
    }

    public int getNullable() {
        IValue v = this.getFieldValue("NULLABLE");
        if (null == v) {
            return 2;
        }
        return v.intValue();
    }

    public void setNullable(int nullable) {
        IntegerValue v = new IntegerValue();
        v.set(nullable);
        this.setFieldValue("NULLABLE", (IValue)v);
    }

    public String getRemarks() {
        IValue v = this.getFieldValue("REMARKS");
        if (null == v) {
            return null;
        }
        return v.stringValue();
    }

    public void setRemarks(String remarks) {
        StringValue v = new StringValue();
        v.set(remarks);
        this.setFieldValue("REMARKS", (IValue)v);
    }
}

