/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.queryspec;

import com.ibm.cognos.aurora.api.model.physical.IPhysicalModel;
import com.ibm.cognos.aurora.api.query.queryspec.IAxisSpecification;
import com.ibm.cognos.aurora.api.query.queryspec.ISetSpecification;
import com.ibm.cognos.aurora.api.query.queryspec.actions.IAxisAction;
import com.ibm.cognos.aurora.api.query.queryspec.visitor.IQueryNodeVisitor;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.qls.query.queryspec.AxisNodeMap;
import com.ibm.cognos.aurora.qls.query.queryspec.QuerySpecAbstractNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AxisSpecification
extends QuerySpecAbstractNode
implements IAxisSpecification {
    public static final String PROPERTY_AXIS_ID = "axisId";
    public static final String PROPERTY_NODES = "nodes";
    private static final String PROPERTY_OPTIONS = "options";
    @Deprecated
    public static final String IS_FILTER_AXIS = "isFilterAxis";

    @Override
    public IPhysicalModel findPhysicalModel() {
        List<AxisNodeMap> nodeList = this.getNodeList();
        if (null == nodeList) {
            return super.findPhysicalModel();
        }
        for (AxisNodeMap map : nodeList) {
            IPhysicalModel model = AxisSpecification.findPhysicalModel(map.getNode());
            if (null == model) continue;
            return model;
        }
        return super.findPhysicalModel();
    }

    public int getType() {
        return 2;
    }

    public void addAxisAction(IAxisAction axisAction) {
        this.addChild((IXQEQueryNode)((QuerySpecAbstractNode)axisAction));
    }

    public void addSetSpecification(ISetSpecification setSpec) {
        this.addChild((IXQEQueryNode)((QuerySpecAbstractNode)setSpec));
    }

    public List<IAxisAction> getAxisActions() {
        IXQEQueryNode[] nodes = this.getChildren();
        ArrayList<IAxisAction> actions = new ArrayList<IAxisAction>();
        for (IXQEQueryNode node : nodes) {
            if (!(node instanceof IAxisAction)) continue;
            actions.add((IAxisAction)node);
        }
        return actions;
    }

    public void setAxisSpecID(int axisID) {
        assert (axisID >= 0);
        this.setPropertyValue(PROPERTY_AXIS_ID, axisID);
    }

    public int getAxisSpecID() {
        return (Integer)this.getPropertyValue(PROPERTY_AXIS_ID);
    }

    public List<ISetSpecification> getSetSpecifications() {
        IXQEQueryNode[] nodes = this.getChildrenOfTypeOrdered(3);
        ArrayList<ISetSpecification> setSpecifications = new ArrayList<ISetSpecification>();
        for (IXQEQueryNode node : nodes) {
            setSpecifications.add((ISetSpecification)node);
        }
        return setSpecifications;
    }

    public List<AxisNodeMap> getNodeList() {
        return (List)this.getPropertyValue(PROPERTY_NODES);
    }

    public void accept(IQueryNodeVisitor visitor) {
        visitor.visit((IAxisSpecification)this);
    }

    @Deprecated
    public boolean isFilterAxis() {
        Boolean filterAxis = (Boolean)this.getPropertyValue(IS_FILTER_AXIS);
        if (filterAxis == null) {
            return false;
        }
        return filterAxis;
    }

    @Deprecated
    protected void setFilterAxis() {
        this.setPropertyValue(IS_FILTER_AXIS, Boolean.TRUE);
    }

    public void setOption(IAxisSpecification.AxisOption option, Object value) {
        Map<IAxisSpecification.AxisOption, Object> optionMap = this.getOptionMap(true);
        optionMap.put(option, value);
    }

    public Object getOption(IAxisSpecification.AxisOption option) {
        Map<IAxisSpecification.AxisOption, Object> optionMap = this.getOptionMap(false);
        if (optionMap == null) {
            return null;
        }
        return optionMap.get(option);
    }

    private Map<IAxisSpecification.AxisOption, Object> getOptionMap(boolean create) {
        HashMap optionMap = (HashMap)this.getPropertyValue(PROPERTY_OPTIONS);
        if (optionMap == null) {
            optionMap = new HashMap();
            this.setPropertyValue(PROPERTY_OPTIONS, optionMap);
        }
        return optionMap;
    }
}

