/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.queryspec;

import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.IDataSource;
import com.ibm.cognos.aurora.api.model.IHierarchy;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalModel;
import com.ibm.cognos.aurora.api.query.queryspec.IAggregationSpecification;
import com.ibm.cognos.aurora.api.query.queryspec.ISelectionSpecification;
import com.ibm.cognos.aurora.api.query.queryspec.actions.ISelectionAction;
import com.ibm.cognos.aurora.api.query.queryspec.visitor.IQueryNodeVisitor;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.qls.exception.QLSMessageKeys;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.model.QueryHierarchyOLAP;
import com.ibm.cognos.aurora.qls.query.queryspec.QuerySpecAbstractNode;
import com.ibm.cognos.aurora.qls.query.queryspec.QuerySpecification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SelectionSpecification
extends QuerySpecAbstractNode
implements ISelectionSpecification {
    public static final String BUSINESSHIERARCHY_PROPERTY = "businesHierarchy";
    public static final String HIERARCHY_PROPERTY = "hierarchy";

    public SelectionSpecification() {
    }

    @Deprecated
    SelectionSpecification(INode[] businessHierarchy) {
        if (businessHierarchy != null && businessHierarchy.length != 0) {
            this.setPropertyValue(BUSINESSHIERARCHY_PROPERTY, businessHierarchy);
        }
    }

    SelectionSpecification(IHierarchy businessHierarchy) {
        if (businessHierarchy != null) {
            this.setPropertyValue(HIERARCHY_PROPERTY, businessHierarchy);
        }
    }

    @Deprecated
    public void setAggregationSpecification(IAggregationSpecification node) {
        if (this.hasChildOfType(2042)) {
            throw new UnsupportedOperationException("SelectionSpecification only supports a single IAggregationSpecification child. Consider using setRollupFunction on IAggregationSpecification, for each metric.");
        }
        this.addChild((IXQEQueryNode)((QuerySpecAbstractNode)node));
    }

    @Override
    public IPhysicalModel findPhysicalModel() {
        IPhysicalModel physicalModel;
        IHierarchy hierarchy;
        INode[] nodes = this.getBusinessHierarchy();
        if (null != nodes) {
            for (INode n : nodes) {
                IPhysicalModel model = SelectionSpecification.findPhysicalModel(n);
                if (null == model) continue;
                return model;
            }
        }
        if ((hierarchy = this.getHierarchy()) == null) {
            return super.findPhysicalModel();
        }
        if (hierarchy instanceof QueryHierarchyOLAP) {
            return ((QueryHierarchyOLAP)hierarchy).getModel();
        }
        IAssociativeModel model = hierarchy.getReferencedModel();
        if (model == null) {
            throw new QLSRuntimeException(QLSMessageKeys.QSP_HierarchyNotBoundToModel, hierarchy.getUniqueName());
        }
        QuerySpecification querySpec = (QuerySpecification)this.getAncestorOfType(0);
        if (querySpec == null) {
            throw new QLSRuntimeException(QLSMessageKeys.QSP_HierarchyNotBoundToModel, hierarchy.getUniqueName());
        }
        IDataSource dataSource = querySpec.getDataSource();
        if (dataSource != null && (physicalModel = model.getPhysicalModel(querySpec.getDataSource().getName())) != null) {
            return physicalModel;
        }
        Collection physicalModels = model.getPhysicalModels();
        if (!physicalModels.isEmpty()) {
            return (IPhysicalModel)physicalModels.iterator().next();
        }
        return super.findPhysicalModel();
    }

    public int getType() {
        return 4;
    }

    public void addSelectionAction(ISelectionAction selectionAction) {
        this.addChild((IXQEQueryNode)((QuerySpecAbstractNode)selectionAction));
    }

    @Deprecated
    public IAggregationSpecification getAggregationSpecification() {
        IXQEQueryNode[] aggrSpecs = this.getChildrenOfType(2042);
        if (aggrSpecs.length > 0) {
            return (IAggregationSpecification)aggrSpecs[0];
        }
        return null;
    }

    public List<ISelectionAction> getSelectionActions() {
        IXQEQueryNode[] nodes = this.getChildren();
        ArrayList<ISelectionAction> actions = new ArrayList<ISelectionAction>();
        for (IXQEQueryNode aNode : nodes) {
            if (!(aNode instanceof ISelectionAction)) continue;
            actions.add((ISelectionAction)aNode);
        }
        return actions;
    }

    public void accept(IQueryNodeVisitor visitor) {
        visitor.visit((ISelectionSpecification)this);
    }

    @Deprecated
    public INode[] getBusinessHierarchy() {
        return (INode[])this.getPropertyValue(BUSINESSHIERARCHY_PROPERTY);
    }

    public IHierarchy getHierarchy() {
        return (IHierarchy)this.getPropertyValue(HIERARCHY_PROPERTY);
    }
}

