/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.storage.data;

import com.ibm.cognos.aurora.api.model.IConnectionSpec;
import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.api.storage.StorageException;
import com.ibm.cognos.aurora.api.storage.data.ILocalDataStorage;
import com.ibm.cognos.aurora.qls.storage.data.LocalDataRepositoryImpl;
import java.io.IOException;
import org.dom4j.DocumentException;

public abstract class AbstractLocalDataStorage
implements ILocalDataStorage {
    protected final IQueryLogicalStorage mQLS;
    private final String mUUID;
    private LocalDataRepositoryImpl mRepo;
    private IConnectionSpec mConnSpec;
    private volatile boolean mDestroyed = false;

    protected AbstractLocalDataStorage(IQueryLogicalStorage qls, String uuid) {
        this.mQLS = qls;
        this.mUUID = uuid;
    }

    protected IQueryLogicalStorage getQLS() {
        return this.mQLS;
    }

    protected final LocalDataRepositoryImpl getRepository() {
        return this.mRepo;
    }

    protected final void setRepository(LocalDataRepositoryImpl repo) {
        this.mRepo = repo;
    }

    public final String getUUID() {
        return this.mUUID;
    }

    public IConnectionSpec getConnectionSpec() {
        return this.mConnSpec;
    }

    protected void setConnectionSpec(IConnectionSpec connSpec) {
        this.mConnSpec = connSpec;
    }

    public abstract void initialize() throws StorageException;

    public abstract void shutdown() throws StorageException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy() throws StorageException {
        if (!this.mDestroyed) {
            try {
                this.destroyImpl();
            }
            finally {
                if (null != this.mRepo) {
                    this.mRepo.removeStorage(this.mUUID);
                }
                this.mDestroyed = true;
            }
        }
    }

    protected abstract void destroyImpl() throws StorageException;

    protected abstract void loadDescriptor() throws IOException, DocumentException;

    protected abstract void saveDescriptor() throws IOException;
}

