/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.storage.data;

import com.ibm.cognos.aurora.api.exception.CoreMessageKeys;
import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.api.storage.StorageException;
import com.ibm.cognos.aurora.api.storage.data.ILocalDataRepository;
import com.ibm.cognos.aurora.api.storage.data.ILocalDataStorage;
import com.ibm.cognos.aurora.api.storage.data.pmta.ILocalPMTAStorage;
import com.ibm.cognos.aurora.api.storage.data.tabular.ILocalTabularStorage;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.cognos.aurora.core.util.ConfigHelper;
import com.ibm.cognos.aurora.qls.exception.QLSMessageKeys;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.storage.data.AbstractLocalDataStorage;
import com.ibm.cognos.aurora.qls.storage.data.pmta.PMTAStorage;
import com.ibm.cognos.aurora.qls.storage.data.tabular.AbstractLocalTabularStorage;
import com.ibm.cognos.aurora.qls.storage.data.tabular.monetdb.LocalMonetDBServer;
import com.ibm.cognos.aurora.qls.storage.data.tabular.monetdb.MonetDBStorage;
import com.ibm.cognos.aurora.qls.util.NetworkUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class LocalDataRepositoryImpl
implements ILocalDataRepository {
    private static final ILogger logger = LoggerManager.getLogger((String)"ATHENA.core.qls");
    private static final String STORAGE_DIR_PATH = "storage";
    private static final String MONETDB_DIR_PATH = "storage/monetdb";
    private static final String MONETDB_DBFARM_DIR_PATH = "storage/monetdb/dbfarm";
    private static final String PMTA_DIR_PATH = "storage/pmta";
    private static final String REPOSITORY_FILE_PATH = "storage/repository.xml";
    private final IQueryLogicalStorage mQLS;
    private LocalMonetDBServer mLocalMonetDBServer;
    private final Map<String, AbstractLocalDataStorage> mStorageByUUID = new HashMap<String, AbstractLocalDataStorage>();

    public LocalDataRepositoryImpl(IQueryLogicalStorage qls) {
        this.mQLS = qls;
    }

    public void initialize() throws StorageException {
        Properties cfg = this.mQLS.getConfigurationProperties();
        if (ConfigHelper.getBoolean((Properties)cfg, (String)"aurora.qls.monetdb.enabled", (boolean)false)) {
            try {
                int portRangeStart;
                int freePort;
                String monetdbInstallPath = ConfigHelper.getString((Properties)cfg, (String)"aurora.qls.monetdb.install_dir");
                if (null == monetdbInstallPath) {
                    throw new StorageException("MonetDB install path was not configured");
                }
                String dbFarmPath = FilenameUtils.concat((String)this.mQLS.getDataDirPath(), (String)MONETDB_DBFARM_DIR_PATH);
                File dbFarmDir = new File(dbFarmPath);
                if (!dbFarmDir.exists()) {
                    try {
                        FileUtils.forceMkdir((File)dbFarmDir);
                    }
                    catch (IOException ex) {
                        throw new StorageException((Throwable)ex);
                    }
                }
                if (-1 == (freePort = NetworkUtil.findFreeTCPPort(portRangeStart = ConfigHelper.getInteger((Properties)cfg, (String)"aurora.qls.monetdb.port", (int)50000)))) {
                    throw new StorageException("No free TCP ports were found");
                }
                this.mLocalMonetDBServer = LocalMonetDBServer.start(monetdbInstallPath, dbFarmPath, freePort, null);
            }
            catch (IOException ex) {
                throw QLSRuntimeException.wrap(ex);
            }
        }
        try {
            this.loadRepositoryIndex();
        }
        catch (Exception ex) {
            throw new StorageException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() throws StorageException {
        try {
            this.saveRepositoryIndex();
        }
        catch (Exception ex) {
            throw new StorageException((Throwable)ex);
        }
        finally {
            try {
                for (AbstractLocalDataStorage s : this.mStorageByUUID.values()) {
                    s.shutdown();
                }
            }
            finally {
                try {
                    if (null != this.mLocalMonetDBServer) {
                        this.mLocalMonetDBServer.shutdown();
                    }
                }
                catch (Throwable ex) {
                    logger.error(ex.getLocalizedMessage(), this.getClass().getName(), ex);
                }
            }
        }
    }

    public IQueryLogicalStorage getQLS() {
        return this.mQLS;
    }

    public Collection<ILocalDataStorage> getStorages() {
        return Collections.unmodifiableCollection(this.mStorageByUUID.values());
    }

    public ILocalDataStorage getStorage(String uuid) {
        return this.mStorageByUUID.get(uuid);
    }

    void removeStorage(String uuid) throws StorageException {
        if (null != this.mStorageByUUID.remove(uuid)) {
            try {
                this.saveRepositoryIndex();
            }
            catch (Exception ex) {
                throw new StorageException((Throwable)ex);
            }
        }
    }

    public ILocalTabularStorage createTabularStorage() throws StorageException {
        String uuid = UUID.randomUUID().toString();
        return this.createTabularStorage(uuid);
    }

    public ILocalTabularStorage createTabularStorage(String uuid) throws StorageException {
        if (this.mStorageByUUID.containsKey(uuid)) {
            throw new StorageException("UUID is already in use: " + uuid);
        }
        AbstractLocalTabularStorage storage = this.newTabularStorageImpl(uuid);
        storage.setRepository(this);
        storage.initialize();
        this.mStorageByUUID.put(uuid, storage);
        try {
            this.saveRepositoryIndex();
        }
        catch (Exception ex) {
            throw new StorageException((Throwable)ex);
        }
        return storage;
    }

    public ILocalPMTAStorage createPMTAStorage() throws StorageException {
        String uuid = UUID.randomUUID().toString();
        return this.createPMTAStorage(uuid);
    }

    public ILocalPMTAStorage createPMTAStorage(String uuid) throws StorageException {
        if (this.mStorageByUUID.containsKey(uuid)) {
            throw new StorageException("UUID is already in use: " + uuid);
        }
        AbstractLocalDataStorage storage = this.newPMTAStorageImpl(uuid);
        storage.setRepository(this);
        storage.initialize();
        this.mStorageByUUID.put(uuid, storage);
        try {
            this.saveRepositoryIndex();
        }
        catch (Exception ex) {
            throw new StorageException((Throwable)ex);
        }
        return (ILocalPMTAStorage)storage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        try {
            for (AbstractLocalDataStorage s : this.mStorageByUUID.values().toArray(new AbstractLocalDataStorage[0])) {
                s.destroy();
            }
        }
        finally {
            try {
                this.saveRepositoryIndex();
            }
            catch (Exception ex) {
                throw new StorageException((Throwable)ex);
            }
        }
    }

    private AbstractLocalTabularStorage newTabularStorageImpl(String uuid) throws StorageException {
        if (null == this.mLocalMonetDBServer) {
            throw new QLSRuntimeException(QLSMessageKeys.PRV_MonetDBNotEnabled);
        }
        String baseDirPath = FilenameUtils.concat((String)this.mQLS.getDataDirPath(), (String)MONETDB_DIR_PATH);
        return new MonetDBStorage(this.mQLS, this.mLocalMonetDBServer, baseDirPath, uuid);
    }

    private AbstractLocalDataStorage newPMTAStorageImpl(String uuid) throws StorageException {
        Properties cfg = this.mQLS.getConfigurationProperties();
        String baseDirPath = FilenameUtils.concat((String)this.mQLS.getDataDirPath(), (String)PMTA_DIR_PATH);
        boolean isInProcess = !"true".equals(cfg.getProperty("aurora.qls.pmta.server_out_of_process"));
        return new PMTAStorage(this.mQLS, baseDirPath, uuid, isInProcess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRepositoryIndex() throws IOException, DocumentException {
        String repoIndexFilePath = FilenameUtils.concat((String)this.mQLS.getDataDirPath(), (String)REPOSITORY_FILE_PATH);
        File repoIndexFile = new File(repoIndexFilePath);
        if (!repoIndexFile.exists()) {
            return;
        }
        SAXReader reader = new SAXReader();
        FileInputStream is = FileUtils.openInputStream((File)repoIndexFile);
        try {
            Document doc = reader.read((InputStream)is);
            this.decodeIndexDocument(doc);
        }
        finally {
            ((InputStream)is).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveRepositoryIndex() throws IOException {
        String storageDirPath = FilenameUtils.concat((String)this.mQLS.getDataDirPath(), (String)STORAGE_DIR_PATH);
        FileUtils.forceMkdir((File)new File(storageDirPath));
        String repoIndexFilePath = FilenameUtils.concat((String)this.mQLS.getDataDirPath(), (String)REPOSITORY_FILE_PATH);
        File repoIndexFile = new File(repoIndexFilePath);
        Document doc = this.encodeIndexDocument();
        OutputFormat format = OutputFormat.createPrettyPrint();
        FileOutputStream os = FileUtils.openOutputStream((File)repoIndexFile);
        try {
            XMLWriter writer = new XMLWriter((OutputStream)os, format);
            writer.write(doc);
            writer.flush();
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    private Document encodeIndexDocument() {
        Document doc = DocumentFactory.getInstance().createDocument("UTF8");
        Element rootElem = doc.addElement("repositoryIndex");
        for (Map.Entry<String, AbstractLocalDataStorage> e : this.mStorageByUUID.entrySet()) {
            String uuid = e.getKey();
            AbstractLocalDataStorage storage = e.getValue();
            Element storageElem = rootElem.addElement(STORAGE_DIR_PATH);
            storageElem.addAttribute("uuid", uuid);
            if (storage.isTabular()) {
                storageElem.addAttribute("type", "tabular");
                continue;
            }
            if (!storage.isDimensional()) continue;
            storageElem.addAttribute("type", "pmta");
        }
        return doc;
    }

    private void decodeIndexDocument(Document doc) throws IOException, DocumentException {
        Element rootElem = doc.getRootElement();
        for (Element storageElem : rootElem.elements(STORAGE_DIR_PATH)) {
            String uuid = storageElem.attributeValue("uuid");
            String type = storageElem.attributeValue("type");
            try {
                AbstractLocalDataStorage storage;
                if ("tabular".equals(type)) {
                    storage = this.newTabularStorageImpl(uuid);
                } else if ("pmta".equals(type)) {
                    storage = this.newPMTAStorageImpl(uuid);
                } else {
                    throw new QLSRuntimeException(CoreMessageKeys.GEN_FoundInternalErrorParam, "Unsupported storage type: " + type);
                }
                storage.loadDescriptor();
                storage.setRepository(this);
                storage.initialize();
                this.mStorageByUUID.put(uuid, storage);
            }
            catch (Exception ex) {
                logger.error(ex.getLocalizedMessage(), this.getClass().getName(), (Throwable)ex);
            }
        }
    }
}

