/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.storage.data.pmta;

import com.ibm.cognos.aurora.api.pmta_bridge.PMTABridgeException;
import com.ibm.cognos.aurora.api.storage.StorageException;
import com.ibm.cognos.aurora.api.storage.data.pmta.IDeployedDimension;
import com.ibm.cognos.aurora.api.storage.data.pmta.ILocalPMTAStorage;
import com.ibm.cognos.aurora.qls.storage.data.pmta.PMTAStorage;

public class DeployedDimension
implements IDeployedDimension {
    private final PMTAStorage mStorage;
    private final String mName;
    private final String mIdentifier;

    public DeployedDimension(PMTAStorage storage, String name, String identifer) {
        this.mStorage = storage;
        this.mName = name;
        this.mIdentifier = identifer;
    }

    public String getName() {
        return this.mName;
    }

    public String getIdentifier() {
        return this.mIdentifier;
    }

    public ILocalPMTAStorage getStorage() {
        return this.mStorage;
    }

    public boolean exists() {
        try {
            return null != this.mStorage.getApplication().getDimension(this.mIdentifier);
        }
        catch (PMTABridgeException ex) {
            throw new StorageException((Throwable)ex);
        }
    }

    public void drop() {
        this.mStorage.dropDimension(this.mName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mIdentifier).append(" (").append(this.mName).append(')');
        return sb.toString();
    }
}

