/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.storage.data.pmta;

import com.ibm.cognos.aurora.api.model.EDataSourceType;
import com.ibm.cognos.aurora.api.model.IConnectionSpec;
import com.ibm.cognos.aurora.api.model.physical.EPhysicalMetadataType;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalModel;
import com.ibm.cognos.aurora.api.pmta_bridge.ICDFDataImporter;
import com.ibm.cognos.aurora.api.pmta_bridge.ICDFDeployResult;
import com.ibm.cognos.aurora.api.pmta_bridge.IPMTAApplication;
import com.ibm.cognos.aurora.api.pmta_bridge.IPMTABridge;
import com.ibm.cognos.aurora.api.pmta_bridge.IPMTADimension;
import com.ibm.cognos.aurora.api.pmta_bridge.ITM1DataDirectory;
import com.ibm.cognos.aurora.api.pmta_bridge.ITM1LocalServer;
import com.ibm.cognos.aurora.api.pmta_bridge.PMTABridgeException;
import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.api.storage.StorageException;
import com.ibm.cognos.aurora.api.storage.data.pmta.IDeployedCube;
import com.ibm.cognos.aurora.api.storage.data.pmta.IDeployedDimension;
import com.ibm.cognos.aurora.api.storage.data.pmta.ILocalPMTAStorage;
import com.ibm.cognos.aurora.core.io.ZipUtil;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.cognos.aurora.core.logging.event.PerfLogEvent;
import com.ibm.cognos.aurora.core.model.ConnectionSpec;
import com.ibm.cognos.aurora.qls.model.LocalDataSource;
import com.ibm.cognos.aurora.qls.model.physical.olap.OlapModelBuilder;
import com.ibm.cognos.aurora.qls.storage.data.AbstractLocalDataStorage;
import com.ibm.cognos.aurora.qls.storage.data.pmta.DeployedCube;
import com.ibm.cognos.aurora.qls.storage.data.pmta.DeployedDimension;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class PMTAStorage
extends AbstractLocalDataStorage
implements ILocalPMTAStorage {
    private static final String DEFAULT_USERNAME = "admin";
    private static final String DEFAULT_PASSWORD = "";
    private final boolean mInProcess;
    private File mDescriptorFile;
    private File mDataArchiveFile;
    private String mUsername = "admin";
    private String mPassword = "";
    private ITM1DataDirectory mDataDir;
    private ITM1LocalServer mLocalServer;
    private IPMTAApplication mApp;
    private final Map<String, IDeployedCube> mCubesByName = new LinkedHashMap<String, IDeployedCube>();
    private final Map<String, IDeployedDimension> mDimsByName = new LinkedHashMap<String, IDeployedDimension>();
    private static final ILogger logger = LoggerManager.getLogger((String)"ATHENA.core.qls");

    public PMTAStorage(IQueryLogicalStorage qls, String baseDirPath, String uuid, boolean isInProcess) {
        super(qls, uuid);
        this.mInProcess = isInProcess;
        this.mDescriptorFile = new File(FilenameUtils.concat((String)baseDirPath, (String)(uuid + ".xml")));
        this.mDataArchiveFile = new File(FilenameUtils.concat((String)baseDirPath, (String)(uuid + ".zip")));
    }

    public boolean isDimensional() {
        return true;
    }

    public boolean isTabular() {
        return false;
    }

    public synchronized void clear() throws StorageException {
        if (logger.isInfoEnabled()) {
            String msg = String.format("Clearing storage (%s)", this.getUUID());
            logger.info(msg, this.getClass().getName() + "::clear()");
        }
        try {
            String msg;
            for (IDeployedCube cube : this.mCubesByName.values()) {
                if (logger.isDebugEnabled()) {
                    msg = String.format("Dropping cube '%s' (%s)", cube.getName(), cube.getIdentifier());
                    logger.debug(msg, this.getClass().getName() + "::clear()");
                }
                this.mApp.dropCube(cube.getIdentifier());
            }
            this.mCubesByName.clear();
            for (IDeployedDimension dim : this.mDimsByName.values()) {
                if (logger.isDebugEnabled()) {
                    msg = String.format("Dropping dimension '%s' (%s)", dim.getName(), dim.getIdentifier());
                    logger.debug(msg, this.getClass().getName() + "::clear()");
                }
                this.mApp.dropDimension(dim.getIdentifier());
            }
            this.mDimsByName.clear();
        }
        catch (PMTABridgeException ex) {
            logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::clear()");
            throw new StorageException((Throwable)ex);
        }
        try {
            this.saveDescriptor();
        }
        catch (Exception ex) {
            logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::clear()");
            throw new StorageException((Throwable)ex);
        }
    }

    public IPhysicalModel buildPhysicalModel(String dataSourceName, ULocale modelLocale) {
        LocalDataSource ds = new LocalDataSource(this.getQLS(), EDataSourceType.DIMENSIONAL, dataSourceName, this.getUUID());
        OlapModelBuilder modelBuilder = new OlapModelBuilder();
        modelBuilder.setDataSource(ds);
        modelBuilder.setLocale(modelLocale);
        modelBuilder.setQLS(this.getQLS());
        for (IDeployedCube iDeployedCube : this.getCubes()) {
            modelBuilder.addCube(this.getCatalogName(), iDeployedCube.getIdentifier());
            modelBuilder.addInternalNameSubstitution(EPhysicalMetadataType.OLAP_CUBE, iDeployedCube.getIdentifier(), iDeployedCube.getName());
        }
        for (IDeployedCube iDeployedCube : this.getDimensions()) {
            modelBuilder.addInternalNameSubstitution(EPhysicalMetadataType.OLAP_DIMENSION, iDeployedCube.getIdentifier(), iDeployedCube.getName());
        }
        return modelBuilder.build();
    }

    public String getCatalogName() {
        return "CATALOG";
    }

    public File getDataArchiveFile() {
        return this.mDataArchiveFile;
    }

    public ITM1LocalServer getLocalServer() {
        return this.mLocalServer;
    }

    public IPMTAApplication getApplication() {
        return this.mApp;
    }

    public synchronized IDeployedCube[] getCubes() throws StorageException {
        return this.mCubesByName.values().toArray(new IDeployedCube[0]);
    }

    public synchronized IDeployedCube getCube(String cubeName) throws StorageException {
        return this.mCubesByName.get(cubeName);
    }

    public synchronized void dropCube(String cubeName) throws StorageException {
        IDeployedCube cube = this.mCubesByName.remove(cubeName);
        if (null != cube) {
            try {
                this.getApplication().dropCube(cube.getIdentifier());
            }
            catch (PMTABridgeException ex) {
                throw new StorageException((Throwable)ex);
            }
            try {
                this.saveDescriptor();
            }
            catch (Exception ex) {
                logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::dropCube()");
                throw new StorageException((Throwable)ex);
            }
        }
    }

    public synchronized IDeployedDimension[] getDimensions() throws StorageException {
        return this.mDimsByName.values().toArray(new IDeployedDimension[0]);
    }

    public synchronized IDeployedDimension getDimension(String dimName) throws StorageException {
        return this.mDimsByName.get(dimName);
    }

    public synchronized void dropDimension(String dimName) throws StorageException {
        IDeployedDimension dim = this.mDimsByName.remove(dimName);
        if (null != dim) {
            try {
                this.getApplication().dropDimension(dim.getIdentifier());
            }
            catch (PMTABridgeException ex) {
                throw new StorageException((Throwable)ex);
            }
            try {
                this.saveDescriptor();
            }
            catch (Exception ex) {
                logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::dropDimension()");
                throw new StorageException((Throwable)ex);
            }
        }
    }

    public synchronized void quickImport(String fileName, String cubeName, ULocale locale) {
        if (logger.isInfoEnabled()) {
            String msg = String.format("Quick import to cube '%s' (locale %s)", cubeName, locale.toLocale());
            logger.info(msg, this.getClass().getName() + "::quickImport()");
        }
        ICDFDataImporter dataImporter = this.mApp.getBridge().getImporter();
        ICDFDeployResult result = dataImporter.quickImport(this.mApp, fileName, cubeName, locale);
        String cubeIdentifier = result.getServerCubeName();
        if (logger.isDebugEnabled()) {
            String msg = String.format("Deployed cube '%s' (%s)", cubeName, cubeIdentifier);
            logger.debug(msg, this.getClass().getName() + "::quickImport()");
        }
        this.mCubesByName.put(cubeName, new DeployedCube(this, cubeName, cubeIdentifier));
        for (String dimName : result.getDimensionNames()) {
            IPMTADimension dim = this.mApp.getDimension(dimName);
            if (logger.isDebugEnabled()) {
                String msg = String.format("Deployed dimension '%s' (%s)", dim.getCaption(), dim.getElementId());
                logger.debug(msg, this.getClass().getName() + "::quickImport()");
            }
            this.mDimsByName.put(dim.getCaption(), new DeployedDimension(this, dim.getCaption(), dim.getElementId()));
        }
        try {
            this.saveDescriptor();
        }
        catch (Exception ex) {
            logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::quickImport()");
            throw new StorageException((Throwable)ex);
        }
    }

    @Override
    public synchronized void initialize() throws StorageException {
        String msg;
        IQueryLogicalStorage qls = this.getQLS();
        if (!qls.isPMTABridgeAvailable()) {
            throw new StorageException("PMTA Bridge was not available.");
        }
        IPMTABridge bridge = qls.getPMTABridge();
        if (logger.isInfoEnabled()) {
            msg = String.format("Initializing storage (%s)", this.getUUID());
            logger.info(msg, this.getClass().getName() + "::initialize()");
        }
        try {
            this.mDataDir = bridge.createPrivateDataDirectory();
            if (logger.isInfoEnabled()) {
                msg = String.format("Created private data directory: %s", this.mDataDir.getDirectory().getAbsolutePath());
                logger.info(msg, this.getClass().getName() + "::initialize()");
            }
            if (this.mDataArchiveFile.exists()) {
                logger.info("Unzipping archive to data directory", this.getClass().getName() + "::initialize()");
                ZipUtil.unzip((File)this.mDataArchiveFile, (File)this.mDataDir.getDirectory());
            }
            PerfLogEvent pEvent = null;
            if (this.mInProcess) {
                if (logger.isPerfDebugEnabled()) {
                    pEvent = logger.startPerfDebug(this.getClass().getName(), "initialize", "Starting in-process TM1 server ...");
                }
                this.mLocalServer = bridge.startInProcessServer(this.mDataDir, this.mUsername, this.mPassword);
                if (pEvent != null) {
                    logger.stopPerfDebug(pEvent, "Started in-process TM1 server");
                }
                this.mApp = bridge.openPrivateClientModel(this.mLocalServer.getSessionID(), this.mLocalServer.getURL(), this.mDataDir.getDirectory().getAbsolutePath(), Locale.ENGLISH);
            } else {
                if (logger.isPerfDebugEnabled()) {
                    pEvent = logger.startPerfDebug(this.getClass().getName(), "initialize", "Starting out-of-process TM1 server ...");
                }
                this.mLocalServer = bridge.startOutOfProcessServer(this.mDataDir, this.mUsername, this.mPassword);
                if (pEvent != null) {
                    logger.stopPerfDebug(pEvent, "Started out-of-process TM1 server");
                }
                this.mApp = bridge.openModel(this.mLocalServer.getSessionID(), this.mLocalServer.getURL(), Locale.ENGLISH);
            }
            ConnectionSpec connSpec = new ConnectionSpec();
            connSpec.setParameterValue("providerType", (Object)"tm1");
            connSpec.setParameterValue("usePMTA", (Object)"true");
            connSpec.setParameterValue("inProcess", (Object)this.mInProcess);
            connSpec.setParameterValue("sessionID", (Object)this.mLocalServer.getSessionID());
            connSpec.setParameterValue("url", (Object)this.mLocalServer.getURL());
            if (this.mInProcess) {
                connSpec.setParameterValue("dataDir", (Object)this.mDataDir.getDirectory().getAbsolutePath());
            }
            connSpec.setParameterValue("localStorageUUID", (Object)this.getUUID());
            this.setConnectionSpec((IConnectionSpec)connSpec);
            this.saveDescriptor();
        }
        catch (Exception ex) {
            logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::initialize()");
            throw new StorageException((Throwable)ex);
        }
    }

    @Override
    public void shutdown() throws StorageException {
        this.shutdown(true);
    }

    private synchronized void shutdown(boolean zipDataDir) throws StorageException {
        block13: {
            String msg;
            if (logger.isInfoEnabled()) {
                msg = String.format("Shutting down storage (%s)", this.getUUID());
                logger.info(msg, this.getClass().getName() + "::shutdown()");
            }
            try {
                if (null != this.mApp) {
                    this.mApp.dispose();
                    this.mApp = null;
                }
                if (null != this.mLocalServer) {
                    if (logger.isInfoEnabled()) {
                        logger.info("Shutting down local TM1 server", this.getClass().getName() + "::shutdown()");
                    }
                    this.mLocalServer.shutdown(false);
                    this.mLocalServer = null;
                }
                if (null == this.mDataDir) break block13;
                try {
                    this.removeTm1sCfgFromDataDir(this.mDataDir.getDirectory().getAbsolutePath());
                    if (zipDataDir) {
                        if (logger.isInfoEnabled()) {
                            msg = String.format("Archiving data directory to: %s", this.mDataArchiveFile.getAbsolutePath());
                            logger.info(msg, this.getClass().getName() + "::shutdown()");
                        }
                        ZipUtil.zipDirectory((File)this.mDataDir.getDirectory(), (File)this.mDataArchiveFile);
                    }
                }
                catch (IOException ex) {
                    logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::shutdown()");
                    throw new StorageException((Throwable)ex);
                }
                if (logger.isInfoEnabled()) {
                    msg = String.format("Deleting data directory: %s", this.mDataDir.getDirectory().getAbsolutePath());
                    logger.info(msg, this.getClass().getName() + "::shutdown()");
                }
                if (!this.mDataDir.delete()) {
                    if (logger.isWarnEnabled()) {
                        logger.warn("Data directory could not be deleted -  Retry will occur on JVM exit", this.getClass().getName() + "::shutdown()");
                    }
                    this.mDataDir.getDirectory().deleteOnExit();
                }
            }
            catch (PMTABridgeException ex) {
                logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::shutdown()");
                throw new StorageException((Throwable)ex);
            }
        }
    }

    private void removeTm1sCfgFromDataDir(String tm1DataDirectoryPath) {
        File tm1sCfgFile = new File(FilenameUtils.concat((String)tm1DataDirectoryPath, (String)"tm1s.cfg"));
        if (tm1sCfgFile.exists()) {
            tm1sCfgFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void destroyImpl() throws StorageException {
        if (logger.isInfoEnabled()) {
            String msg = String.format("Destroying storage (%s)", this.getUUID());
            logger.info(msg, this.getClass().getName() + "::destroyImpl()");
        }
        try {
            String msg;
            for (IDeployedCube cube : this.mCubesByName.values()) {
                if (logger.isDebugEnabled()) {
                    msg = String.format("Dropping cube '%s' (%s)", cube.getName(), cube.getIdentifier());
                    logger.debug(msg, this.getClass().getName() + "::destroyImpl()");
                }
                try {
                    this.mApp.dropCube(cube.getIdentifier());
                }
                catch (Throwable ex) {
                    logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::destroyImpl()", ex);
                }
            }
            this.mCubesByName.clear();
            for (IDeployedDimension dim : this.mDimsByName.values()) {
                if (logger.isDebugEnabled()) {
                    msg = String.format("Dropping dimension '%s' (%s)", dim.getName(), dim.getIdentifier());
                    logger.debug(msg, this.getClass().getName() + "::destroyImpl()");
                }
                try {
                    this.mApp.dropDimension(dim.getIdentifier());
                }
                catch (Throwable ex) {
                    logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::destroyImpl()", ex);
                }
            }
            this.mDimsByName.clear();
        }
        finally {
            try {
                this.shutdown(false);
            }
            finally {
                try {
                    if (this.mDescriptorFile.exists()) {
                        FileUtils.forceDelete((File)this.mDescriptorFile);
                    }
                }
                catch (IOException ex) {
                    logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::destroyImpl()", (Throwable)ex);
                }
                try {
                    if (this.mDataArchiveFile.exists()) {
                        FileUtils.forceDelete((File)this.mDataArchiveFile);
                    }
                }
                catch (IOException ex) {
                    logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::destroyImpl()", (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadDescriptor() throws IOException, DocumentException {
        FileInputStream is = FileUtils.openInputStream((File)this.mDescriptorFile);
        try {
            SAXReader reader = new SAXReader();
            Document doc = reader.read((InputStream)is);
            this.decodeDescriptorDocument(doc);
        }
        finally {
            ((InputStream)is).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveDescriptor() throws IOException {
        Document doc = this.encodeDescriptorDocument();
        OutputFormat format = OutputFormat.createPrettyPrint();
        FileOutputStream os = FileUtils.openOutputStream((File)this.mDescriptorFile);
        try {
            XMLWriter writer = new XMLWriter((OutputStream)os, format);
            writer.write(doc);
            writer.flush();
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    private Document encodeDescriptorDocument() {
        Document doc = DocumentFactory.getInstance().createDocument("UTF8");
        Element rootElem = doc.addElement("pmtaStorage");
        rootElem.addElement("uuid").setText(this.getUUID());
        rootElem.addElement("inProcess").setText(Boolean.toString(this.mInProcess));
        rootElem.addElement("username").setText(this.mUsername);
        rootElem.addElement("password").setText(this.mPassword);
        Element deployedDimsElem = rootElem.addElement("deployedDimensions");
        for (IDeployedDimension dim : this.mDimsByName.values()) {
            Element dimElem = deployedDimsElem.addElement("dimension");
            dimElem.addAttribute("name", dim.getName());
            dimElem.addAttribute("identifier", dim.getIdentifier());
        }
        Element deployedCubesElem = rootElem.addElement("deployedCubes");
        for (IDeployedCube cube : this.mCubesByName.values()) {
            Element cubeElem = deployedCubesElem.addElement("cube");
            cubeElem.addAttribute("name", cube.getName());
            cubeElem.addAttribute("identifier", cube.getIdentifier());
        }
        return doc;
    }

    private void decodeDescriptorDocument(Document doc) {
        Element rootElem = doc.getRootElement();
        this.mUsername = rootElem.elementText("username");
        this.mPassword = rootElem.elementText("password");
        this.mDimsByName.clear();
        Element deployedDimsElem = rootElem.element("deployedDimensions");
        for (Element dimElem : deployedDimsElem.elements("dimension")) {
            String name = dimElem.attributeValue("name");
            String identifier = dimElem.attributeValue("identifier");
            this.mDimsByName.put(name, new DeployedDimension(this, name, identifier));
        }
        this.mCubesByName.clear();
        Element deployedCubesElem = rootElem.element("deployedCubes");
        for (Element cubeElem : deployedCubesElem.elements("cube")) {
            String name = cubeElem.attributeValue("name");
            String identifier = cubeElem.attributeValue("identifier");
            this.mCubesByName.put(name, new DeployedCube(this, name, identifier));
        }
    }
}

