/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.storage.data.tabular.monetdb;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.apache.commons.io.FilenameUtils;

public final class LocalMonetDBServer {
    public static final String DB_NAME = "aurora_db";
    public static final String HOSTNAME = "localhost";
    public static final String USERNAME = "monetdb";
    public static final String PASSWORD = "monetdb";
    private static final String MSERVER5 = "bin" + File.separatorChar + "mserver5";
    private final Process mProcess;
    private final int mPort;
    private final String mDBFarmPath;

    public static LocalMonetDBServer start(String monetdbInstallPath, String dbFarmPath, int port, File outputFile) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        monetdbInstallPath = FilenameUtils.normalizeNoEndSeparator((String)monetdbInstallPath);
        pb.environment().putAll(System.getenv());
        boolean upperCasePath = pb.environment().containsKey("PATH");
        String originalPath = null;
        originalPath = upperCasePath ? pb.environment().get("PATH") : pb.environment().get("Path");
        StringBuilder pathBuilder = new StringBuilder();
        LocalMonetDBServer.appendPathComponents(pathBuilder, monetdbInstallPath, "bin");
        pathBuilder.append(File.pathSeparatorChar);
        LocalMonetDBServer.appendPathComponents(pathBuilder, monetdbInstallPath, "lib");
        pathBuilder.append(File.pathSeparatorChar);
        LocalMonetDBServer.appendPathComponents(pathBuilder, monetdbInstallPath, "lib", "monetdb5");
        if (null != originalPath) {
            pathBuilder.append(File.pathSeparatorChar);
            pathBuilder.append(originalPath);
        }
        if (upperCasePath) {
            pb.environment().put("PATH", pathBuilder.toString());
        } else {
            pb.environment().put("Path", pathBuilder.toString());
        }
        pb.redirectErrorStream(true);
        pb.directory(new File(monetdbInstallPath));
        Process process = null;
        try {
            process = LocalMonetDBServer.createProcessWithDBPath(pb, dbFarmPath, monetdbInstallPath, port);
        }
        catch (Exception ex) {
            process = LocalMonetDBServer.createProcessWithDBFarm(pb, dbFarmPath, monetdbInstallPath, port);
        }
        FileOutputStream logStream = null;
        if (null != outputFile) {
            try {
                logStream = new FileOutputStream(outputFile);
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        new InputGobbler(DB_NAME, process.getInputStream(), logStream).start();
        return new LocalMonetDBServer(process, port, dbFarmPath);
    }

    private static Process createProcessWithDBFarm(ProcessBuilder pb, String dbFarmPath, String monetdbInstallPath, int port) throws IOException {
        pb.command(monetdbInstallPath + File.separatorChar + MSERVER5, "--set", "\"prefix=" + monetdbInstallPath + "\"", "--set", "\"exec_prefix=" + monetdbInstallPath + "\"", "--set", "\"mapi_port=" + Integer.toString(port) + "\"", "--dbfarm=" + FilenameUtils.normalizeNoEndSeparator((String)dbFarmPath), "--dbname=aurora_db");
        Process process = pb.start();
        LocalMonetDBServer.waitForPrompt(process);
        return process;
    }

    private static Process createProcessWithDBPath(ProcessBuilder pb, String dbFarmPath, String monetdbInstallPath, int port) throws IOException {
        pb.command(monetdbInstallPath + File.separatorChar + MSERVER5, "--set", "\"prefix=" + monetdbInstallPath + "\"", "--set", "\"exec_prefix=" + monetdbInstallPath + "\"", "--set", "\"mapi_port=" + Integer.toString(port) + "\"", "--dbpath=" + FilenameUtils.normalizeNoEndSeparator((String)(dbFarmPath + "/" + DB_NAME)));
        Process process = pb.start();
        LocalMonetDBServer.waitForPrompt(process);
        return process;
    }

    private static void appendPathComponents(StringBuilder sb, String prefix, String ... components) {
        sb.append(prefix);
        for (String c : components) {
            sb.append(File.separatorChar).append(c);
        }
    }

    private static void waitForPrompt(Process p) throws IOException {
        InputStream is = p.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder messageBuf = new StringBuilder();
        while (true) {
            int ch;
            if (-1 == (ch = reader.read())) {
                throw new EOFException("Unexpected End-Of-File. Console messages: " + messageBuf.toString());
            }
            if ((char)ch == '>') {
                return;
            }
            messageBuf.append((char)ch);
            String line = reader.readLine();
            if (null == line) {
                throw new EOFException("Unexpected End-Of-File. Console messages: " + messageBuf.toString());
            }
            messageBuf.append(line).append("\n");
        }
    }

    private LocalMonetDBServer(Process process, int port, String dbFarmPath) {
        this.mProcess = process;
        this.mPort = port;
        this.mDBFarmPath = dbFarmPath;
    }

    public String getHostName() {
        return HOSTNAME;
    }

    public int getPort() {
        return this.mPort;
    }

    public String getDBFarmPath() {
        return this.mDBFarmPath;
    }

    public String getDBName() {
        return DB_NAME;
    }

    public String getUserName() {
        return "monetdb";
    }

    public String getPassword() {
        return "monetdb";
    }

    public OutputStream getOutputStream() {
        return this.mProcess.getOutputStream();
    }

    public InputStream getInputStream() {
        return this.mProcess.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws IOException, InterruptedException {
        try {
            this.mProcess.getOutputStream().close();
            Thread.sleep(500L);
            this.mProcess.destroy();
        }
        finally {
            this.mProcess.waitFor();
        }
    }

    private static final class InputGobbler
    extends Thread {
        private final InputStream mIn;
        private final OutputStream mLogStream;

        public InputGobbler(String dbName, InputStream in, OutputStream logStream) {
            this.mIn = in;
            this.mLogStream = logStream;
            this.setDaemon(true);
            this.setName("MonetDB-InputGobbler-" + dbName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int b;
                do {
                    b = this.mIn.read();
                    if (null == this.mLogStream) continue;
                    this.mLogStream.write(b);
                    this.mLogStream.flush();
                } while (-1 != b);
            }
            catch (IOException ex) {
                return;
            }
            finally {
                try {
                    if (null != this.mLogStream) {
                        this.mLogStream.close();
                    }
                }
                catch (IOException ex) {
                    return;
                }
            }
        }
    }
}

