/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.storage.data.tabular.monetdb;

import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.api.storage.StorageException;
import com.ibm.cognos.aurora.api.storage.data.tabular.IBatchRowInsert;
import com.ibm.cognos.aurora.api.storage.data.tabular.ILocalTabularStorage;
import com.ibm.cognos.aurora.api.storage.data.tabular.ITable;
import com.ibm.cognos.aurora.core.io.CSVWriter;
import com.ibm.cognos.aurora.core.io.TempFile;
import java.io.File;
import java.io.IOException;

public class MonetDBBatchInsert
implements IBatchRowInsert {
    private static final String CSV_FIELD_SEP = ",";
    private static final String CSV_RECORD_SEP = "\n";
    private static final String CSV_ENCAPSULATOR = "\"";
    private static final String CSV_NULL = "\u0003";
    private final IQueryLogicalStorage mQLS;
    private final ITable mTable;
    private File mTempFile;
    private CSVWriter mCSVWriter = null;
    private int mRowCount = 0;

    public MonetDBBatchInsert(IQueryLogicalStorage qls, ITable table) {
        this.mQLS = qls;
        this.mTable = table;
    }

    public void begin() throws StorageException {
        if (null != this.mCSVWriter) {
            throw new IllegalStateException("begin() called twice without matching finish()");
        }
        this.mRowCount = 0;
        try {
            this.mTempFile = TempFile.createTempFile((File)new File(this.mQLS.getTempDirPath()), (String)"importTable_", (String)"csv");
            this.mCSVWriter = new CSVWriter(this.mTempFile, CSV_FIELD_SEP, CSV_RECORD_SEP, CSV_ENCAPSULATOR, CSV_NULL);
        }
        catch (IOException ex) {
            throw new StorageException((Throwable)ex);
        }
    }

    public void addRow(IValue[] row) throws StorageException {
        if (null == this.mCSVWriter) {
            throw new IllegalStateException("addRow() was called before begin()");
        }
        ILocalTabularStorage storage = this.mTable.getStorage();
        String[] formattedValues = new String[row.length];
        for (int i = 0; i < row.length; ++i) {
            if (null == row[i]) continue;
            formattedValues[i] = storage.formatValueForCSV(row[i]);
        }
        this.mCSVWriter.writeRecord(formattedValues);
        ++this.mRowCount;
    }

    public void addRow(Object[] row) throws StorageException {
        if (null == this.mCSVWriter) {
            throw new IllegalStateException("addRow() was called before begin()");
        }
        this.mCSVWriter.writeRecord(row);
        ++this.mRowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() throws StorageException {
        if (null == this.mCSVWriter) {
            throw new IllegalStateException("finish() called before begin()");
        }
        this.mCSVWriter.close();
        try {
            this.mTable.importCSV(this.mTempFile, (long)this.mRowCount, CSV_FIELD_SEP, CSV_RECORD_SEP, CSV_ENCAPSULATOR, CSV_NULL);
        }
        finally {
            this.mTempFile.delete();
        }
    }
}

