/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.storage.data.tabular.monetdb;

import com.ibm.cognos.aurora.api.model.value.DateTimeValue;
import com.ibm.cognos.aurora.api.model.value.DateValue;
import com.ibm.cognos.aurora.api.model.value.TimeValue;
import com.ibm.cognos.aurora.api.model.value.TimestampValue;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.ULocale;

public final class MonetDBDateFormat {
    private static final ULocale EN_US = new ULocale("en_US");
    private static final ThreadLocal<LocalDateFormats> LOCAL_FORMATS = new ThreadLocal<LocalDateFormats>(){

        @Override
        protected LocalDateFormats initialValue() {
            return new LocalDateFormats();
        }
    };

    private MonetDBDateFormat() {
    }

    public static String formatDate(DateValue date) {
        return LOCAL_FORMATS.get().formatDate(date);
    }

    public static String formatTime(TimeValue time) {
        return LOCAL_FORMATS.get().formatTime(time);
    }

    public static String formatTimestamp(TimestampValue timestamp) {
        return LOCAL_FORMATS.get().formatTimestamp(timestamp);
    }

    static /* synthetic */ ULocale access$000() {
        return EN_US;
    }

    private static final class LocalDateFormats {
        private final Calendar mCalendar;
        private final DateFormat mDateFormat = new SimpleDateFormat("yyyy-MMM-dd", MonetDBDateFormat.access$000());
        private final DateFormat mTimeFormat = new SimpleDateFormat("HH:mm:ss:SSS ZZZZ", MonetDBDateFormat.access$000());
        private final DateFormat mTimestampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS ZZZZ", MonetDBDateFormat.access$000());

        LocalDateFormats() {
            this.mCalendar = DateTimeValue.getISO8601Calendar();
            this.mDateFormat.setCalendar(this.mCalendar);
            this.mTimeFormat.setCalendar(this.mCalendar);
            this.mTimestampFormat.setCalendar(this.mCalendar);
        }

        String formatDate(DateValue date) {
            this.mCalendar.setTimeZone(date.getTimeZone());
            this.mCalendar.setTimeInMillis(date.getTimeInMillis());
            this.mCalendar.clear(16);
            return this.mDateFormat.format(this.mCalendar.getTime());
        }

        String formatTimestamp(TimestampValue timestamp) {
            this.mCalendar.setTimeZone(timestamp.getTimeZone());
            this.mCalendar.setTimeInMillis(timestamp.getTimeInMillis());
            this.mCalendar.clear(16);
            return this.mTimestampFormat.format(this.mCalendar.getTime());
        }

        String formatTime(TimeValue time) {
            this.mCalendar.setTimeZone(time.getTimeZone());
            this.mCalendar.setTimeInMillis(time.getTimeInMillis());
            this.mCalendar.clear(16);
            return this.mTimeFormat.format(this.mCalendar.getTime());
        }
    }
}

