/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.storage.data.tabular.monetdb;

import com.ibm.cognos.aurora.api.exception.CoreMessageKeys;
import com.ibm.cognos.aurora.api.model.EDataSourceType;
import com.ibm.cognos.aurora.api.model.IConnectionSpec;
import com.ibm.cognos.aurora.api.model.physical.EPhysicalMetadataType;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalModel;
import com.ibm.cognos.aurora.api.model.value.DateValue;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.TimeValue;
import com.ibm.cognos.aurora.api.model.value.TimestampValue;
import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.api.query.provider.tabular.ITabularDataProvider;
import com.ibm.cognos.aurora.api.storage.StorageException;
import com.ibm.cognos.aurora.api.storage.data.tabular.ColumnConstraint;
import com.ibm.cognos.aurora.api.storage.data.tabular.ColumnType;
import com.ibm.cognos.aurora.api.storage.data.tabular.IBatchRowInsert;
import com.ibm.cognos.aurora.api.storage.data.tabular.IColumnDescriptor;
import com.ibm.cognos.aurora.api.storage.data.tabular.ITable;
import com.ibm.cognos.aurora.api.storage.data.tabular.ITableDescriptor;
import com.ibm.cognos.aurora.api.storage.data.tabular.SequenceParameters;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.cognos.aurora.core.model.ConnectionSpec;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.model.LocalDataSource;
import com.ibm.cognos.aurora.qls.model.physical.rel.RelModelBuilder;
import com.ibm.cognos.aurora.qls.query.provider.relational.JDBCProviderConnection;
import com.ibm.cognos.aurora.qls.storage.data.tabular.AbstractLocalTabularStorage;
import com.ibm.cognos.aurora.qls.storage.data.tabular.monetdb.LocalMonetDBServer;
import com.ibm.cognos.aurora.qls.storage.data.tabular.monetdb.MonetDBBatchInsert;
import com.ibm.cognos.aurora.qls.storage.data.tabular.monetdb.MonetDBDateFormat;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class MonetDBStorage
extends AbstractLocalTabularStorage {
    private final LocalMonetDBServer mLocalServer;
    private final String mDescriptorFilePath;
    private final ITabularDataProvider mDataProvider;
    private static final ILogger logger = LoggerManager.getLogger((String)"ATHENA.core.qls");

    public MonetDBStorage(IQueryLogicalStorage qls, LocalMonetDBServer localServer, String baseDirPath, String uuid) throws StorageException {
        super(qls, uuid);
        this.mLocalServer = localServer;
        this.mDescriptorFilePath = FilenameUtils.concat((String)baseDirPath, (String)(uuid + ".xml"));
        this.mDataProvider = (ITabularDataProvider)qls.getProviderManager().getDataProvider("monetdb");
    }

    @Override
    public synchronized void initialize() throws StorageException {
        ConnectionSpec connSpec = new ConnectionSpec();
        connSpec.setParameterValue("providerType", (Object)"monetdb");
        connSpec.setParameterValue("jdbcConnectionString", (Object)this.buildConnectionString());
        connSpec.setParameterValue("dbName", (Object)this.mLocalServer.getDBName());
        connSpec.setParameterValue("user", (Object)this.mLocalServer.getUserName());
        connSpec.setParameterValue("password", (Object)this.mLocalServer.getPassword());
        connSpec.setParameterValue("localStorageUUID", (Object)this.getUUID());
        this.setConnectionSpec((IConnectionSpec)connSpec);
        try {
            this.saveDescriptor();
        }
        catch (Exception ex) {
            throw new StorageException((Throwable)ex);
        }
        if (logger.isDebugEnabled()) {
            String msg = String.format("Initialized MonetDB Storage with UUID %s", this.getUUID());
            logger.debug(msg, this.getClass().getName() + "::initialize()");
        }
    }

    @Override
    public synchronized void shutdown() throws StorageException {
        if (logger.isDebugEnabled()) {
            String msg = String.format("Shutdown MonetDB Storage with UUID %s", this.getUUID());
            logger.debug(msg, this.getClass().getName() + "::initialize()");
        }
    }

    private String buildConnectionString() {
        try {
            return new URI("jdbc:monetdb", null, this.mLocalServer.getHostName(), this.mLocalServer.getPort(), "/" + this.mLocalServer.getDBName(), null, null).toString();
        }
        catch (URISyntaxException ex) {
            throw QLSRuntimeException.wrap(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dropTableImpl(String tableIdent) throws StorageException {
        if (logger.isDebugEnabled()) {
            String msg = String.format("Dropping table '%s'", tableIdent);
            logger.debug(msg, this.getClass().getName() + "::dropTableImpl()");
        }
        if (!this.queryTableExists(tableIdent)) {
            logger.debug("Table does not exist", this.getClass().getName() + "::dropTableImpl()");
            return;
        }
        try {
            JDBCProviderConnection conn = (JDBCProviderConnection)this.mDataProvider.getConnectionPool().borrow(this.getConnectionSpec());
            try {
                Statement statement = conn.getJDBCConnection().createStatement();
                try {
                    String sql = String.format("DROP TABLE \"%s\"", tableIdent);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Execute Update: " + sql, this.getClass().getName() + "::dropTableImpl()");
                    }
                    statement.executeUpdate(sql);
                }
                finally {
                    statement.close();
                }
            }
            finally {
                conn.returnToPool();
            }
        }
        catch (SQLException ex) {
            logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::dropTableImpl()");
            throw new StorageException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createTableImpl(ITableDescriptor tableDesc) throws StorageException {
        String msg;
        if (logger.isDebugEnabled()) {
            msg = String.format("Creating table '%s'", tableDesc.getIdentifier());
            logger.debug(msg, this.getClass().getName() + "::createTableImpl()");
        }
        if (this.queryTableExists(tableDesc.getIdentifier())) {
            msg = String.format("Existing table will be clobbered '%s'", tableDesc.getIdentifier());
            logger.warn(msg, this.getClass().getName() + "::createTableImpl()");
            this.dropTableImpl(tableDesc.getIdentifier());
        }
        try {
            JDBCProviderConnection conn = (JDBCProviderConnection)this.mDataProvider.getConnectionPool().borrow(this.getConnectionSpec());
            try {
                Statement statement = conn.getJDBCConnection().createStatement();
                try {
                    String sql = this.renderCreateTableStatement(tableDesc);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Execute Update: " + sql, this.getClass().getName() + "::createTableImpl()");
                    }
                    statement.executeUpdate(sql);
                }
                finally {
                    statement.close();
                }
            }
            finally {
                conn.returnToPool();
            }
        }
        catch (SQLException ex) {
            logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::createTableImpl()");
            throw new StorageException((Throwable)ex);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    protected boolean queryTableExists(String tableIdent) throws StorageException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getCatalogName() {
        return "aurora_db";
    }

    public String getSchemaName() {
        return "sys";
    }

    public IBatchRowInsert prepareBatchInsert(String tableName) throws StorageException {
        ITable table = this.getTable(tableName);
        if (null == table) {
            throw new StorageException("Table not found: " + tableName);
        }
        return new MonetDBBatchInsert(this.mQLS, table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importCSV(String tableName, File csvFile, String fieldSeparator, String recordSeparator, String encapsulator, String nullString) throws StorageException {
        if (!csvFile.exists()) {
            throw new IllegalArgumentException("CSV file does not exist: " + csvFile.toString());
        }
        ITable table = this.getTable(tableName);
        if (null == table) {
            throw new StorageException("Table does not exist: " + tableName);
        }
        if (logger.isDebugEnabled()) {
            String msg = String.format("Importing CSV file '%s' into table '%s'", csvFile.getPath(), tableName);
            logger.debug(msg, this.getClass().getName() + "::importCSV()");
        }
        StringBuilder command = new StringBuilder();
        command.append("COPY INTO \"").append(table.getIdentifier()).append("\" FROM '").append(FilenameUtils.normalize((String)csvFile.getAbsolutePath())).append("' USING DELIMITERS '").append(fieldSeparator).append("', '").append(recordSeparator);
        if (null != encapsulator) {
            command.append("', '").append(encapsulator);
        }
        command.append("' NULL AS '").append(nullString).append("';");
        try {
            JDBCProviderConnection conn = (JDBCProviderConnection)this.mDataProvider.getConnectionPool().borrow(this.getConnectionSpec());
            try {
                Statement statement = conn.getJDBCConnection().createStatement();
                try {
                    String sql = command.toString();
                    if (logger.isDebugEnabled()) {
                        logger.debug("Execute Update: " + sql, this.getClass().getName() + "::importCSV()");
                    }
                    statement.executeUpdate(sql);
                }
                finally {
                    statement.close();
                }
            }
            finally {
                conn.returnToPool();
            }
        }
        catch (SQLException ex) {
            logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::importCSV()");
            throw new StorageException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importCSV(String tableName, long recordCount, File csvFile, String fieldSeparator, String recordSeparator, String encapsulator, String nullString) throws StorageException {
        if (!csvFile.exists()) {
            throw new IllegalArgumentException("CSV file does not exist: " + csvFile.toString());
        }
        ITable table = this.getTable(tableName);
        if (null == table) {
            throw new StorageException("Table does not exist: " + tableName);
        }
        if (logger.isDebugEnabled()) {
            String msg = String.format("Importing CSV file '%s' into table '%s'", csvFile.getPath(), tableName);
            logger.debug(msg, this.getClass().getName() + "::importCSV()");
        }
        StringBuilder command = new StringBuilder();
        command.append("COPY ").append(Long.toString(recordCount)).append(" RECORDS INTO \"").append(table.getIdentifier()).append("\" FROM '").append(FilenameUtils.normalize((String)csvFile.getAbsolutePath())).append("' USING DELIMITERS '").append(fieldSeparator).append("', '").append(recordSeparator);
        if (null != encapsulator) {
            command.append("', '").append(encapsulator);
        }
        command.append("' NULL AS '").append(nullString).append("';");
        try {
            JDBCProviderConnection conn = (JDBCProviderConnection)this.mDataProvider.getConnectionPool().borrow(this.getConnectionSpec());
            try {
                Statement statement = conn.getJDBCConnection().createStatement();
                try {
                    String sql = command.toString();
                    if (logger.isDebugEnabled()) {
                        logger.debug("Execute Update: " + sql, this.getClass().getName() + "::importCSV()");
                    }
                    statement.executeUpdate(sql);
                }
                finally {
                    statement.close();
                }
            }
            finally {
                conn.returnToPool();
            }
        }
        catch (SQLException ex) {
            throw new StorageException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTable(String tableName) throws StorageException {
        ITable table = this.getTable(tableName);
        if (null == table) {
            throw new StorageException("Table does not exist: " + tableName);
        }
        if (logger.isDebugEnabled()) {
            String msg = String.format("Clearing table '%s'", tableName);
            logger.debug(msg, this.getClass().getName() + "::clearTable()");
        }
        try {
            JDBCProviderConnection conn = (JDBCProviderConnection)this.mDataProvider.getConnectionPool().borrow(this.getConnectionSpec());
            try {
                Statement statement = conn.getJDBCConnection().createStatement();
                try {
                    String sql = String.format("DELETE FROM \"%s\"", table.getIdentifier());
                    if (logger.isDebugEnabled()) {
                        logger.debug("Execute Update: " + sql, this.getClass().getName() + "::clearTable()");
                    }
                    statement.executeUpdate(sql);
                }
                finally {
                    statement.close();
                }
            }
            finally {
                conn.returnToPool();
            }
        }
        catch (SQLException ex) {
            throw new StorageException((Throwable)ex);
        }
    }

    private String convertToSQLType(ColumnType columnType) {
        switch (columnType.getBaseType()) {
            case -5: {
                return "BIGINT";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 1: {
                return String.format("CHAR(%d)", columnType.getParams()[0]);
            }
            case 2005: {
                return "CLOB";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return String.format("DECIMAL(%d, %d)", columnType.getParams()[0], columnType.getParams()[1]);
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INT";
            }
            case 7: {
                return "REAL";
            }
            case 5: {
                return "SMALLINT";
            }
            case 93: {
                if (columnType.getParams().length == 0) {
                    return "TIMESTAMP";
                }
                if (Boolean.TRUE.equals(columnType.getParams()[1])) {
                    return String.format("TIMESTAMP(%d) WITH TIME ZONE", columnType.getParams()[0]);
                }
                return String.format("TIMESTAMP(%d)", columnType.getParams()[0]);
            }
            case 92: {
                if (columnType.getParams().length == 0) {
                    return "TIME";
                }
                if (Boolean.TRUE.equals(columnType.getParams()[1])) {
                    return String.format("TIME(%d) WITH TIME ZONE", columnType.getParams()[0]);
                }
                return String.format("TIME(%d)", columnType.getParams()[0]);
            }
            case -6: {
                return "TINYINT";
            }
            case 12: {
                return String.format("VARCHAR(%d)", columnType.getParams()[0]);
            }
        }
        throw new QLSRuntimeException(CoreMessageKeys.GEN_FoundInternalErrorParam, "Unsupported ColumnType: " + columnType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void destroyImpl() throws StorageException {
        try {
            for (ITable t : this.getTables()) {
                try {
                    t.drop();
                }
                catch (Exception ex) {
                    logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::destroyImpl()", (Throwable)ex);
                }
            }
        }
        finally {
            try {
                this.shutdown();
            }
            finally {
                File descriptorFile = new File(this.mDescriptorFilePath);
                try {
                    if (descriptorFile.exists()) {
                        FileUtils.forceDelete((File)descriptorFile);
                    }
                }
                catch (IOException ex) {
                    logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::destroyImpl()", (Throwable)ex);
                    descriptorFile.deleteOnExit();
                }
            }
        }
    }

    public IPhysicalModel buildPhysicalModel(String dataSourceName, ULocale modelLocale) {
        LocalDataSource ds = new LocalDataSource(this.getQLS(), EDataSourceType.RELATIONAL, dataSourceName, this.getUUID());
        RelModelBuilder modelBuilder = new RelModelBuilder();
        modelBuilder.setDataSource(ds);
        modelBuilder.setLocale(modelLocale);
        modelBuilder.setQLS(this.getQLS());
        for (ITable table : this.getTables()) {
            ITableDescriptor tableDesc = table.getDescriptor();
            modelBuilder.addTable(this.getCatalogName(), this.getSchemaName(), tableDesc.getIdentifier());
            modelBuilder.addInternalNameSubstitution(EPhysicalMetadataType.REL_TABLE, tableDesc.getIdentifier(), tableDesc.getName());
            for (IColumnDescriptor colDesc : tableDesc.getColumns()) {
                modelBuilder.addInternalNameSubstitution(EPhysicalMetadataType.REL_COLUMN, colDesc.getIdentifier(), colDesc.getName());
            }
        }
        return modelBuilder.build();
    }

    public String formatValueForCSV(IValue v) {
        if (null == v || v.isNull()) {
            return null;
        }
        switch (v.getType().getBaseType()) {
            case TIMESTAMP: {
                return MonetDBDateFormat.formatTimestamp((TimestampValue)v);
            }
            case TIME: {
                return MonetDBDateFormat.formatTime((TimeValue)v);
            }
            case DATE: {
                return MonetDBDateFormat.formatDate((DateValue)v);
            }
        }
        return v.stringValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadDescriptor() throws IOException, DocumentException {
        File descriptorFile = new File(this.mDescriptorFilePath);
        FileInputStream is = FileUtils.openInputStream((File)descriptorFile);
        try {
            SAXReader reader = new SAXReader();
            Document doc = reader.read((InputStream)is);
            this.decodeDescriptorDocument(doc);
        }
        finally {
            ((InputStream)is).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveDescriptor() throws IOException {
        Document doc = this.encodeDescriptorDocument();
        OutputFormat format = OutputFormat.createPrettyPrint();
        File descriptorFile = new File(this.mDescriptorFilePath);
        FileOutputStream os = FileUtils.openOutputStream((File)descriptorFile);
        try {
            XMLWriter writer = new XMLWriter((OutputStream)os, format);
            writer.write(doc);
            writer.flush();
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    private Document encodeDescriptorDocument() {
        Document doc = DocumentFactory.getInstance().createDocument("UTF8");
        Element rootElem = doc.addElement("monetDbStorage");
        rootElem.addElement("uuid").setText(this.getUUID());
        this.encodeDescriptorTables(rootElem);
        return doc;
    }

    private void decodeDescriptorDocument(Document doc) {
        Element rootElem = doc.getRootElement();
        this.decodeDescriptorTables(rootElem);
    }

    private String renderCreateTableStatement(ITableDescriptor tableDesc) {
        StringBuilder sb = new StringBuilder();
        boolean firstElement = true;
        sb.append("CREATE TABLE \"").append(tableDesc.getIdentifier()).append("\" (");
        for (IColumnDescriptor c : tableDesc.getColumns()) {
            if (firstElement) {
                firstElement = false;
            } else {
                sb.append(", ");
            }
            this.appendTableElement(sb, c);
        }
        String[] primaryKeyColumns = tableDesc.getPrimaryKeyColumns();
        String[] uniqueColumns = tableDesc.getUniqueColumns();
        if (primaryKeyColumns != null && primaryKeyColumns.length > 0) {
            MonetDBStorage.appendPrimaryKeyColumns(sb, tableDesc, primaryKeyColumns);
        }
        if (uniqueColumns != null && uniqueColumns.length > 0) {
            MonetDBStorage.appendUniqueColumns(sb, tableDesc, uniqueColumns);
        }
        sb.append(')');
        return sb.toString();
    }

    private void appendTableElement(StringBuilder sb, IColumnDescriptor columnDesc) {
        sb.append("\"").append(columnDesc.getIdentifier()).append("\" ").append(this.convertToSQLType(columnDesc.getType()));
        if (columnDesc.isAutoIncrement()) {
            sb.append(" AUTO_INCREMENT");
        } else if (columnDesc.isGenerateAsIdentity()) {
            SequenceParameters identParams = columnDesc.getIdentityParameters();
            sb.append(" GENERATED ALWAYS AS IDENTITY ");
            if (null != identParams) {
                sb.append('(');
                if (null != identParams.mStartWith) {
                    sb.append(" START WITH ").append(identParams.mStartWith.toString());
                }
                if (null != identParams.mIncrementBy) {
                    sb.append(" INCREMENT BY ").append(identParams.mIncrementBy.toString());
                }
                if (null != identParams.mMinValue) {
                    sb.append(" MINVALUE ").append(identParams.mMinValue.toString());
                }
                if (null != identParams.mMaxValue) {
                    sb.append(" MAXVALUE ").append(identParams.mMaxValue.toString());
                }
                if (null != identParams.mCache) {
                    sb.append(" CACHE ").append(identParams.mCache.toString());
                }
                if (null != identParams.mCycle) {
                    if (identParams.mCycle.booleanValue()) {
                        sb.append(" CYCLE ");
                    } else {
                        sb.append(" NOCYCLE ");
                    }
                }
                sb.append(')');
            }
        }
        if (null != columnDesc.getDefaultValue()) {
            sb.append(" DEFAULT ");
            MonetDBStorage.appendLiteral(sb, columnDesc.getDefaultValue(), columnDesc.getType());
        }
        if (null != columnDesc.getConstraints()) {
            for (ColumnConstraint c : columnDesc.getConstraints()) {
                sb.append(" ").append(c.toSQL());
            }
        }
    }

    private static void appendPrimaryKeyColumns(StringBuilder sb, ITableDescriptor tableDesc, String[] columnNames) {
        boolean firstElement = true;
        sb.append(", PRIMARY KEY (");
        for (String c : columnNames) {
            String ident = tableDesc.getColumn(c).getIdentifier();
            if (firstElement) {
                firstElement = false;
            } else {
                sb.append(", ");
            }
            sb.append('\"').append(ident).append('\"');
        }
        sb.append(')');
    }

    private static void appendUniqueColumns(StringBuilder sb, ITableDescriptor tableDesc, String[] columnNames) {
        boolean firstElement = true;
        sb.append(", UNIQUE (");
        for (String c : columnNames) {
            String ident = tableDesc.getColumn(c).getIdentifier();
            if (firstElement) {
                firstElement = false;
            } else {
                sb.append(", ");
            }
            sb.append('\"').append(ident).append('\"');
        }
        sb.append(')');
    }

    private static void appendLiteral(StringBuilder sb, Object value, ColumnType dataType) {
        if (null == value) {
            sb.append("null");
            return;
        }
        boolean quoteIt = dataType.isString();
        if (quoteIt) {
            sb.append('\'');
        }
        sb.append(value.toString());
        if (quoteIt) {
            sb.append('\'');
        }
    }
}

