/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.util;

import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;

public final class NetworkUtil {
    private static final ILogger logger = LoggerManager.getLogger((String)"ATHENA.core.qls");
    public static final int MIN_PORT = 0;
    public static final int MAX_PORT = 65535;
    private static final int SOCK_TIMEOUT = 200;
    private static String LOCALHOST_NAME = null;
    private static String LOCALHOST_ADDRESS = null;

    public static String getLocalHostName() {
        if (null == LOCALHOST_NAME) {
            try {
                LOCALHOST_NAME = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception ex) {
                throw QLSRuntimeException.wrap(ex);
            }
        }
        return LOCALHOST_NAME;
    }

    public static String getLocalHostAddress() {
        if (null == LOCALHOST_ADDRESS) {
            try {
                LOCALHOST_ADDRESS = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception ex) {
                throw QLSRuntimeException.wrap(ex);
            }
        }
        return LOCALHOST_ADDRESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTCPPortFree(int port) {
        Socket sock = null;
        boolean tcpBound = false;
        try {
            sock = new Socket();
            sock.setReuseAddress(true);
            sock.connect(new InetSocketAddress("localhost", port), 200);
            tcpBound = true;
        }
        catch (Exception ex) {
            boolean bl = true;
            return bl;
        }
        finally {
            if (tcpBound) {
                try {
                    sock.close();
                }
                catch (Exception ex) {
                    logger.error(ex.getLocalizedMessage(), NetworkUtil.class.getName(), (Throwable)ex);
                }
            }
        }
        return false;
    }

    public static int findFreeTCPPort(int portRangeStart) {
        return NetworkUtil.findFreeTCPPort(portRangeStart, 65535);
    }

    public static int findFreeTCPPort(int portRangeStart, int portRangeEnd) {
        for (int port = portRangeStart; port <= portRangeEnd; ++port) {
            if (!NetworkUtil.isTCPPortFree(port)) continue;
            return port;
        }
        return -1;
    }

    private NetworkUtil() {
    }
}

