/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.util;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class WorkerPool
extends ThreadPoolExecutor {
    public static final int DEFAULT_CORE_POOL_SIZE = Math.max(2, Runtime.getRuntime().availableProcessors() / 2);
    public static final int DEFAULT_MAX_POOL_SIZE = 2 * DEFAULT_CORE_POOL_SIZE;
    public static final int DEFAULT_KEEP_ALIVE_TIME = 60;
    private final String mPoolName;

    public WorkerPool(String poolName) {
        this(poolName, DEFAULT_CORE_POOL_SIZE, DEFAULT_MAX_POOL_SIZE, 60);
    }

    public WorkerPool(String poolName, int corePoolSize, int maxPoolSize, int keepAliveTime) {
        super(corePoolSize, maxPoolSize, (long)keepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new WorkerThreadFactory(poolName));
        this.mPoolName = poolName;
    }

    public final String getPoolName() {
        return this.mPoolName;
    }

    private static final class WorkerThreadFactory
    implements ThreadFactory {
        private final String mPoolName;
        private AtomicLong mThreadCounter = new AtomicLong(0L);

        public WorkerThreadFactory(String poolName) {
            this.mPoolName = poolName;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread t = new Thread(runnable);
            t.setDaemon(true);
            t.setName(this.mPoolName + "-" + this.mThreadCounter.incrementAndGet());
            return t;
        }
    }
}

