/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp;

import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.bibus.SoapFaultException;
import com.cognos.pogo.contentmanager.CMClass;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.bibushandler.Commands;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.datasource.DataSourceConnection;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.IDataSourceConnectionSignon;
import com.cognos.xqe.data.model.IUsernamePasswordSignon;
import com.cognos.xqe.data.providers.ConnectionTestQueryArguments;
import com.cognos.xqe.data.providers.relational.AbstractConnection;
import com.cognos.xqe.data.providers.relational.IRelationalConnection;
import com.cognos.xqe.data.providers.relational.SQLQueryArguments;
import com.cognos.xqe.data.providers.relational.erp.ERPDataProvider;
import com.cognos.xqe.data.providers.relational.erp.ERPException;
import com.cognos.xqe.data.providers.relational.erp.ERPLog;
import com.cognos.xqe.data.providers.relational.erp.ERPTabularResult;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.exception.XQESOAPFaultException;
import com.cognos.xqe.pool.connection.IInstrumentedPooledConnection;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.IColumnInfo;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.caching.CachedResultSetManager;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.security.IEncryptedObject;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqebifw.bibushandler.content.CMQuery;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.dom4j.Element;

public abstract class ERPConnection
extends AbstractConnection
implements IInstrumentedPooledConnection,
IRelationalConnection {
    private static final String CM_PROXY_SEARCH_PATH_TEMPLATE = "CAMID(\":\")/dataSource[@name='NAME']/dataSourceConnection[@name='NAME']/credential[@name='proxy']";
    private static final Pattern PATTERN = Pattern.compile("NAME");
    private static final String CM_CREDENTIAL = "cm:credential";
    private static final String PROP_CREDENTIALS = "credentials";
    private static final String VALUE = "value";
    private static final String URL_MATCH_PATTERN = "URL=";
    private static final String DRIVER_NAME_PATTERN = "DRIVER_NAME=";
    protected static final String CONNECTION_SIGNON = "signon";
    private Map<String, Object> properties = new HashMap<String, Object>();
    protected CachedResultSetManager cacheMgr = null;
    protected String connectionString;
    private String dsType;
    private String url;
    private String driverClassName;
    private Connection jdbcConnection;
    private String userId;
    private String password;
    private DataSourceConnection.Credentials proxyCreds;

    public ERPConnection(IDataSource dataSource) {
        super(dataSource);
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        boolean cachingEnabled = config.getBooleanProperty("general.cacheResultSets[@enabled]", true);
        int memory = config.getIntProperty("general.cacheResultSets[@maxMemory]", 64);
        int threshold = config.getIntProperty("general.cacheResultSets[@threshold]", 10);
        this.cacheMgr = new CachedResultSetManager(cachingEnabled, memory, threshold);
        IDataSourceConnection dsConnection = dataSource.getDataSourceConnection();
        this.connectionString = dsConnection.getConnectionString(null);
        this.dsType = dataSource.getType();
        int index = this.connectionString.indexOf(URL_MATCH_PATTERN);
        if (index > -1) {
            this.url = this.connectionString.substring(index + URL_MATCH_PATTERN.length());
        }
        this.driverClassName = this.getDriverName(this.connectionString);
        IDataSourceConnectionSignon dataSourceConnectionSignon = dsConnection.getSignon();
        if (dataSourceConnectionSignon != null && dataSourceConnectionSignon instanceof IUsernamePasswordSignon) {
            this.userId = ((IUsernamePasswordSignon)dataSourceConnectionSignon).getUserName();
            if (((IUsernamePasswordSignon)dataSourceConnectionSignon).getPassword() != null) {
                this.password = (String)((IUsernamePasswordSignon)dataSourceConnectionSignon).getPassword().decrypt();
            }
        }
        if (this.isSFDC()) {
            this.fetchProxyInformation();
        }
    }

    private String getDriverName(String connStr) {
        String[] tokens;
        for (String token : tokens = connStr.split(";")) {
            String[] driverNameTokens;
            if (token.indexOf(DRIVER_NAME_PATTERN) <= -1 || (driverNameTokens = token.split("=")).length != 2) continue;
            return driverNameTokens[1];
        }
        return null;
    }

    public String getConnectionCollationSequence() {
        return null;
    }

    public String getDatabaseCharset() {
        return null;
    }

    public String getDatabaseCollationSequence() {
        return null;
    }

    public Set<Object> getCachingStatistics() {
        return this.cacheMgr.getCachedEntrySet();
    }

    public void disconnect() throws ERPException {
        this.cacheMgr.release();
    }

    public abstract void connect(Locale var1);

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public void setProperty(String key, Object val) {
        this.properties.put(key, val);
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public ITabularResultSet getResultSet(XDataContext nonCacheableContext, IPooledConnection pooledConnection, SQLQueryArguments queryArgs, Integer nodeId, ERPDataProvider erpDataProvider) {
        ITabularResultSet erpTabularResult;
        boolean useCachedResults;
        String key = queryArgs.getSQLQuery();
        boolean bl = useCachedResults = queryArgs.isCacheable() && this.cacheMgr.isCachingEnabled();
        if (useCachedResults && (erpTabularResult = this.cacheMgr.getCachedResultSet(key)) != null) {
            pooledConnection.returnConnection();
            return erpTabularResult;
        }
        boolean cacheResultSet = useCachedResults;
        XDataContext context = cacheResultSet ? new XDataContext(null, nonCacheableContext.getEnvironment()) : nonCacheableContext;
        ERPTabularResult erpTabularResult2 = this.getResultSetImpl(context, pooledConnection, queryArgs, nodeId, erpDataProvider);
        IRowsetInfo rowsetInfo = erpTabularResult2.getTabularRowsetInfo();
        ERPTabularResult resultSet = erpTabularResult2;
        if (cacheResultSet && rowsetInfo != null) {
            cacheResultSet = true;
            for (IColumnInfo columnInfo : rowsetInfo.getColumnInfos()) {
                if (!columnInfo.getDataType().isBlob()) continue;
                cacheResultSet = false;
                break;
            }
            if (cacheResultSet) {
                IDataSource ds = queryArgs.getDataSource();
                resultSet = this.cacheMgr.createCachedResultSet(context, (ITabularResultSet)erpTabularResult2, (CachedResultSetManager.IPooledConnectionDelegator)erpTabularResult2, erpDataProvider.getResourceTracker(), key, ds.getName());
                if (resultSet != erpTabularResult2) {
                    erpTabularResult2.setIsCaching(true);
                }
            }
        }
        if (erpTabularResult2 == resultSet && nonCacheableContext != context) {
            context.attachToParentAndTakeReference(nonCacheableContext);
        }
        return resultSet;
    }

    protected abstract ERPTabularResult getResultSetImpl(XDataContext var1, IPooledConnection var2, SQLQueryArguments var3, Integer var4, ERPDataProvider var5);

    public static boolean testConnection(ConnectionTestQueryArguments theQueryArguments) {
        ERPLog.getLogger(LogLevel.ERROR).log("ERP Test Connect error");
        return false;
    }

    public synchronized Connection getConnection() {
        if (this.jdbcConnection != null) {
            return this.jdbcConnection;
        }
        try {
            Driver driver = (Driver)Class.forName(this.getDriverClassName()).newInstance();
            Properties connProp = new Properties();
            connProp.put("user", this.userId);
            connProp.put("password", this.password);
            if (this.isSFDC() && this.getProxyUser() != null) {
                connProp.put("proxyUserName", this.getProxyUser());
                connProp.put("proxyPassword", this.getProxyPassword());
            }
            this.jdbcConnection = driver.connect(this.url, connProp);
            return this.jdbcConnection;
        }
        catch (IllegalAccessException e) {
            throw new XQERuntimeException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new XQERuntimeException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new XQERuntimeException((Throwable)e);
        }
        catch (SQLException e) {
            throw new XQERuntimeException((Throwable)e);
        }
    }

    protected String getProxyUser() {
        if (this.proxyCreds != null) {
            return this.proxyCreds.getUsername();
        }
        return null;
    }

    protected String getProxyPassword() {
        IEncryptedObject proxyPasswdEncrypted;
        if (this.proxyCreds != null && (proxyPasswdEncrypted = this.proxyCreds.getPassword()) != null) {
            return (String)proxyPasswdEncrypted.decrypt();
        }
        return null;
    }

    protected void fetchProxyInformation() {
        ExecutionEnvironment env = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (((RequestEnvironment)env.getRequestEnvironment()).getRequestEnvelope() == null) {
            return;
        }
        Element localbiBusHeader = (Element)((Element)((RequestEnvironment)env.getRequestEnvironment()).getBibusHeader().clone()).detach();
        CMQuery query = new CMQuery("");
        query.setQueryObject(ERPConnection.buildSearchPath(this.dataSource.getName()));
        query.setBIBusHeader(localbiBusHeader);
        query.addQueryPropertyName(PropEnum.defaultName.getValue());
        query.addQueryPropertyName(PropEnum.searchPath.getValue());
        query.addQueryPropertyName(PropEnum.credentials.getValue());
        for (Commands cmd : Commands.values()) {
            query.addQueryPropertyName(cmd.getName());
        }
        List resultList = null;
        try {
            query.execute();
            resultList = CollectionCast.uncheckedCast((List)query.getResultList());
        }
        catch (SoapFaultException sfe) {
            BIBusEnvelope faultEnvelope = query.getResponseEnvelope();
            throw new XQESOAPFaultException(faultEnvelope, (Throwable)sfe);
        }
        catch (CommandExecutionException e) {
            throw new XQERuntimeException(XQEMessageKeys.CM_UnableToRetrieveDataSource, (Throwable)e, this.dataSource.getName());
        }
        for (CMClass cmResult : resultList) {
            DataSourceConnection.Credentials creds;
            String cmClassName = cmResult.getCMClassName();
            if (!cmClassName.equals(CM_CREDENTIAL)) continue;
            Element credsEle = cmResult.getPropertyAsElement(PROP_CREDENTIALS);
            Element valueEle = credsEle.element(VALUE);
            this.proxyCreds = creds = DataSourceConnection.retrieveCredentials((String)valueEle.getText());
        }
    }

    private boolean isSFDC() {
        String erpPrefix;
        String subType;
        return this.dsType != null && (subType = this.dsType.substring((erpPrefix = "ERP-").length())).equalsIgnoreCase(ERPDataProvider.ERPDataProviderType.SFDC.name());
    }

    private static String buildSearchPath(String name) {
        return PATTERN.matcher(CM_PROXY_SEARCH_PATH_TEMPLATE).replaceAll(name);
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getDatabaseType() {
        return this.dsType;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUserId() {
        return this.userId;
    }
}

