/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp;

import com.cognos.xqe.data.model.DataSourceException;
import com.cognos.xqe.data.model.ICAMCryptoSignon;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.IDataSourceConnectionSignon;
import com.cognos.xqe.data.model.IUsernamePasswordSignon;
import com.cognos.xqe.data.providers.connection.parameters.DataSourceParameter;
import com.cognos.xqe.data.providers.relational.erp.ERPConnection;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionSelector;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.pool.connection.ISelectorContext;

public class ERPConnectionSelector
implements IConnectionSelector {
    public IConnectionSelector.ReturnCode selectConnection(ConnectionParameters connectionParameters, ISelectorContext context, IPooledConnection pooledConnection) {
        ERPConnection connection = (ERPConnection)((Object)pooledConnection.getConnection());
        IDataSource dataSource = (IDataSource)connectionParameters.valueOf(DataSourceParameter.class, IDataSource.class);
        IDataSource pooledDataSource = connection.getDataSource();
        IDataSourceConnectionSignon signon = dataSource.getDataSourceConnection().getSignon();
        String userName = "";
        if (signon != null && signon.getType() == IDataSourceConnectionSignon.SignonType.USERNAME_PASSWORD) {
            userName = ((IUsernamePasswordSignon)signon).getUserName();
        }
        String pooledUserName = "";
        IDataSourceConnectionSignon pooledSignon = null;
        try {
            pooledSignon = (IDataSourceConnectionSignon)connection.getProperty("signon");
        }
        catch (DataSourceException de) {
            pooledSignon = null;
            pooledUserName = null;
        }
        String pooledCryptoHandle = "";
        String cryptoHandle = "";
        if (pooledSignon != null) {
            if (pooledSignon.getType() == IDataSourceConnectionSignon.SignonType.USERNAME_PASSWORD) {
                pooledUserName = ((IUsernamePasswordSignon)pooledSignon).getUserName();
            } else if (pooledSignon.getType() == IDataSourceConnectionSignon.SignonType.CAMCRYPTO) {
                pooledCryptoHandle = ((ICAMCryptoSignon)pooledSignon).getCryptoHandle();
                if (signon != null && signon.getType() == IDataSourceConnectionSignon.SignonType.CAMCRYPTO) {
                    cryptoHandle = ((ICAMCryptoSignon)signon).getCryptoHandle();
                }
            }
        }
        String pooledDSType = "pooledType";
        String pooledDSName = "pooledName";
        if (pooledDataSource != null) {
            pooledDSType = pooledDataSource.getType();
            pooledDSName = pooledDataSource.getName();
        }
        String dsType = "dsType";
        String dsName = "dsName";
        String dsConnectionString = "dsConnectionString";
        if (dataSource != null) {
            dsType = dataSource.getType();
            dsName = dataSource.getName();
            IDataSourceConnection dataSourceConnection = dataSource.getDataSourceConnection();
            if (null != dataSourceConnection) {
                dsConnectionString = dataSourceConnection.getConnectionString(signon);
            }
        }
        String pooledCxnString = "";
        if (connection.getConnectionString() != null) {
            pooledCxnString = connection.getConnectionString();
        }
        boolean status = false;
        if (cryptoHandle == null || pooledCryptoHandle == null) {
            status = dsType.equals(pooledDSType) && userName.equals(pooledUserName) && pooledCxnString.equals(dsConnectionString) && pooledDSName.equals(dsName);
        } else {
            boolean bl = status = dsType.equals(pooledDSType) && userName.equals(pooledUserName) && pooledCxnString.equals(dsConnectionString) && pooledDSName.equals(dsName) && pooledCryptoHandle.equals(cryptoHandle);
        }
        if (status) {
            connection.setDataSource(dataSource);
            return IConnectionSelector.ReturnCode.MATCH;
        }
        return IConnectionSelector.ReturnCode.NOT_MATCH;
    }
}

