/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp;

import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.providers.ConnectionTestQueryArguments;
import com.cognos.xqe.data.providers.DataProviderBase;
import com.cognos.xqe.data.providers.connection.ConnectionFactoryStatisticsDecorator;
import com.cognos.xqe.data.providers.relational.IRelationalDataProvider;
import com.cognos.xqe.data.providers.relational.SQLQueryArguments;
import com.cognos.xqe.data.providers.relational.erp.ERPConnection;
import com.cognos.xqe.data.providers.relational.erp.ERPConnectionFactory;
import com.cognos.xqe.data.providers.relational.erp.ERPConnectionSelector;
import com.cognos.xqe.data.providers.relational.erp.ERPLog;
import com.cognos.xqe.data.providers.relational.erp.siebel.SiebelConnection;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionFactory;
import com.cognos.xqe.pool.connection.IConnectionSelector;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.ConnectionUtil;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

public class ERPDataProvider
extends DataProviderBase
implements IRelationalDataProvider {
    private final IConnectionSelector connectionSelector = new ERPConnectionSelector();
    private final IConnectionFactory connectionFactory;
    private final ERPConnectionFactory erpConnectionFactory = new ERPConnectionFactory();

    public ERPDataProvider(String instanceName, Properties properties) {
        super(instanceName, properties);
        this.connectionFactory = new ConnectionFactoryStatisticsDecorator((IConnectionFactory)this.erpConnectionFactory, this.getProviderInstanceName());
    }

    public void releaseImpl() {
    }

    public IConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public IConnectionSelector getConnectionSelector() {
        return this.connectionSelector;
    }

    public ITabularResultSet query(XDataContext context, SQLQueryArguments queryArgs) throws XQEException, LogonFailureException {
        ERPLog.getLogger(LogLevel.TRACE).log("ErpLog ERPDataProvider.query");
        IExecutionEnvironment env = context.getEnvironment();
        IPooledConnection pooledConnection = ConnectionUtil.getPooledConnection((IExecutionEnvironment)env, (IDataSource)queryArgs.getDataSource());
        ERPConnection connection = (ERPConnection)((Object)pooledConnection.getConnection());
        env.registerDataSourceCollationInformation(connection.getDatabaseCollationSequence(), connection.getConnectionCollationSequence());
        ITabularResultSet resultSet = connection.getResultSet(context, pooledConnection, queryArgs, context.getNodeId(), this);
        return resultSet;
    }

    public List<XQEMessage> testConnection(ConnectionTestQueryArguments theQueryArguments) {
        ERPLog.getLogger(LogLevel.TRACE).log("ErpLog ERPDataProvider.testConnection");
        IDataSource dataSource = theQueryArguments.getDataSource();
        Locale runLocale = theQueryArguments.getExecutionEnvironment().getRequestEnvironment().getRunLocale();
        ConnectionParameters connectionParameters = ConnectionUtil.createConnectionParameters((Locale)runLocale, (IDataSource)dataSource);
        boolean result = false;
        String erpPrefix = "ERP-";
        String dbType = dataSource.getType();
        if (dbType.startsWith(erpPrefix)) {
            String subType = dbType.substring(erpPrefix.length());
            if (ERPDataProviderType.SIEBEL.name().equalsIgnoreCase(subType)) {
                result = SiebelConnection.testConnection(theQueryArguments);
            } else if (ERPDataProviderType.SAP.name().equalsIgnoreCase(subType)) {
                ERPConnection connection = (ERPConnection)((Object)this.erpConnectionFactory.createConnection(connectionParameters));
                this.erpConnectionFactory.destroyConnection(connection);
                result = true;
            } else if (ERPDataProviderType.SFDC.name().equalsIgnoreCase(subType)) {
                ERPConnection connection = (ERPConnection)((Object)this.erpConnectionFactory.createConnection(connectionParameters));
                this.erpConnectionFactory.destroyConnection(connection);
                result = true;
            } else {
                result = ERPConnection.testConnection(theQueryArguments);
            }
        }
        if (!result) {
            if (ERPLog.getLogger().isOn()) {
                ERPLog.getLogger().log("Error in test-connection for data-source: " + dataSource);
            }
            throw new XQERuntimeException(XQEMessageKeys.DS_DataSourceConnectionFailure);
        }
        return null;
    }

    public IPooledConnection borrowConnection(ConnectionParameters connectionParameters, IExecutionEnvironment executionEnvironment) {
        return executionEnvironment.getConnectionPool().borrowConnection(this.getProviderInstanceName(), connectionParameters, this.connectionSelector, this.connectionFactory);
    }

    public static enum ERPDataProviderType {
        SIEBEL,
        SAP,
        SFDC;

    }
}

