/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp.sap;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPLogger;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPLoggerFactory;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;

public class SAPConfiguration {
    private static final String HANDLE_SAP_DATE_TIME = "handleSAPDateTime.dateTime(";
    private static final String SAP_RFC = "sapRFC.rfc(";
    private static SAPLogger logger = SAPLoggerFactory.getLogger(SAPConfiguration.class);
    private static final String ROW_LENGTH = "rowLength";
    private static final String PARSE_DECIMAL_VALUES = "parseDecimalValues";
    private static final String CONFIG_FILE_PATH = "/xqeerp.config.xml";
    private String sapTableQueryBatchSize;
    private int maxNoOfThreads;
    private Map<String, Properties> rfcProps = new HashMap<String, Properties>();
    private Map<String, String> dateTimeValues = new HashMap<String, String>(2);

    public static void main(String[] args) {
        SAPConfiguration conf = new SAPConfiguration();
    }

    public SAPConfiguration() {
        this.loadSAPConfiguration();
        this.dateTimeValues.put("00000000", null);
    }

    public String getSapTableQueryBatchSize() {
        return this.sapTableQueryBatchSize;
    }

    public int getMaxNoOfThreads() {
        return this.maxNoOfThreads;
    }

    public Map<String, String> getDateTimeValues() {
        return Collections.unmodifiableMap(this.dateTimeValues);
    }

    private void loadSAPConfiguration() {
        XQEConfiguration xqeConfig = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        if (xqeConfig == null) {
            return;
        }
        String configFilePath = xqeConfig.getConfigDirectory() + CONFIG_FILE_PATH;
        File confFilePath = new File(configFilePath);
        if (!confFilePath.exists()) {
            logger.error("Configuration file not exist");
            return;
        }
        try {
            int i;
            XMLConfiguration xmlConfig = new XMLConfiguration(configFilePath);
            List list = xmlConfig.configurationsAt("datasources.datasource");
            HierarchicalConfiguration sapConf = null;
            for (HierarchicalConfiguration conf : list) {
                String type = conf.getString("[@type]");
                if (type == null || !type.equals("ERP-SAP")) continue;
                sapConf = conf;
                break;
            }
            this.sapTableQueryBatchSize = sapConf.getString("performance.sapTableQueryBatchSize[@value]");
            this.maxNoOfThreads = sapConf.getInt("performance.maxNoOfThreads[@value]");
            String[] array = sapConf.getStringArray("sapRFC.rfc[@name]");
            for (i = 0; i < array.length; ++i) {
                String rfcname = sapConf.getString(SAP_RFC + i + ").[@name]");
                String rowLength = sapConf.getString(SAP_RFC + i + ").[@rowLength]");
                String parseDecimal = sapConf.getString(SAP_RFC + i + ").[@parseDecimalValues]");
                Properties prop = new Properties();
                prop.put(ROW_LENGTH, rowLength);
                prop.put(PARSE_DECIMAL_VALUES, parseDecimal);
                this.rfcProps.put(rfcname, prop);
            }
            array = sapConf.getStringArray("handleSAPDateTime.dateTime[@sapValue]");
            for (i = 0; i < array.length; ++i) {
                String sapvalue = sapConf.getString(HANDLE_SAP_DATE_TIME + i + ").[@sapValue]");
                String displayvalue = sapConf.getString(HANDLE_SAP_DATE_TIME + i + ").[@displayValue]");
                this.dateTimeValues.put(sapvalue, displayvalue);
            }
            if (logger.isDebug()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Advanced configuration: sapTableQueryBatchSize ");
                sb.append(this.sapTableQueryBatchSize);
                sb.append(" maxNoOfThreads ");
                sb.append(this.maxNoOfThreads);
                sb.append(" RFC props ");
                sb.append(this.rfcProps);
                sb.append(" Datetime values ");
                sb.append(this.dateTimeValues);
                logger.debug(sb.toString());
            }
        }
        catch (ConfigurationException e) {
            logger.error(configFilePath, e);
        }
    }

    public int getRowLength(String rfc) {
        Properties prop = this.rfcProps.get(rfc);
        if (prop != null) {
            return Integer.parseInt(prop.getProperty(ROW_LENGTH));
        }
        return -1;
    }

    public boolean isParseDecimalEnabled(String rfc) {
        Properties prop = this.rfcProps.get(rfc);
        if (prop != null) {
            return Boolean.parseBoolean(prop.getProperty(PARSE_DECIMAL_VALUES));
        }
        return false;
    }

    public boolean areRFCPropertiesConfigured(String rfc) {
        return this.rfcProps.containsKey(rfc);
    }
}

