/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp.sap;

import com.cognos.xqe.ast.sql.SQLBetween;
import com.cognos.xqe.ast.sql.SQLColumn;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLIn;
import com.cognos.xqe.ast.sql.SQLIsNull;
import com.cognos.xqe.ast.sql.SQLLike;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.data.providers.relational.erp.ERPException;
import com.cognos.xqe.data.providers.relational.erp.sap.SAPWhereClauseHandler;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPLogger;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPLoggerFactory;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPRFCInvocation;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import java.util.ArrayList;
import java.util.List;

public class SAPRFCWhereClauseHandler
extends SAPWhereClauseHandler {
    private static final String TYPE = "RFCs";
    private final List<SAPRFCInvocation> filters = new ArrayList<SAPRFCInvocation>();
    private static SAPLogger logger = SAPLoggerFactory.getLogger(SAPRFCWhereClauseHandler.class);

    public SAPRFCWhereClauseHandler(String tabName, List<IMetadata> querySubjectList) {
        super(tabName, querySubjectList);
    }

    @Override
    public void handle(SQLLogical logicalExpr) {
        if (logger.isDebug()) {
            logger.debug("SQLLogical " + logicalExpr);
        }
        if (logicalExpr.getNumberChildren() == 1) {
            throw new XQERuntimeException();
        }
        this.handle((SQLQueryNode)logicalExpr.getChild(0));
        ArrayList<SAPRFCInvocation> filtersLeftNode = new ArrayList<SAPRFCInvocation>(this.filters);
        this.filters.clear();
        this.handle((SQLQueryNode)logicalExpr.getChild(1));
        ArrayList<SAPRFCInvocation> filtersRightNode = new ArrayList<SAPRFCInvocation>(this.filters);
        String operator = this.getOperator(logicalExpr.getSubType());
        this.filters.clear();
        if (operator.equals("AND")) {
            this.filters.addAll(this.mergeInvocationLists(filtersLeftNode, filtersRightNode));
        } else {
            this.filters.addAll(filtersLeftNode);
            this.filters.addAll(filtersRightNode);
        }
    }

    private List<SAPRFCInvocation> mergeInvocationLists(List<SAPRFCInvocation> list1, List<SAPRFCInvocation> list2) {
        if (logger.isDebug()) {
            logger.debug("Merging invocation lists");
            logger.debug("List-1 " + list1);
            logger.debug("List-2 " + list2);
        }
        ArrayList<SAPRFCInvocation> mergedInvList = new ArrayList<SAPRFCInvocation>();
        for (SAPRFCInvocation rfcFunInv1 : list1) {
            for (SAPRFCInvocation rfcFunInv2 : list2) {
                SAPRFCInvocation inv = new SAPRFCInvocation(this.tableName);
                inv.addImportParams(rfcFunInv1.getImportParams());
                inv.addImportParams(rfcFunInv2.getImportParams());
                inv.addTableRowFilters(rfcFunInv1.getTableParams());
                inv.addTableRowFilters(rfcFunInv2.getTableParams());
                mergedInvList.add(inv);
            }
        }
        if (logger.isDebug()) {
            logger.debug("Merged lists " + mergedInvList);
        }
        return mergedInvList;
    }

    @Override
    public void handle(SQLLike likeExpr) {
        throw new ERPException(XQEMessageKeys.ERP_OperatorNotSupported, "LIKE", TYPE);
    }

    @Override
    public void handle(SQLIsNull isnullExpr) {
        throw new ERPException(XQEMessageKeys.ERP_OperatorNotSupported, "ISNULL", TYPE);
    }

    @Override
    public void handle(SQLIn inExpr) {
        if (logger.isDebug()) {
            logger.debug("SQLIn " + inExpr.dumpToString());
        }
        SQLColumn column = (SQLColumn)inExpr.getChild(0);
        SQLValueList list = (SQLValueList)inExpr.getChild(1);
        int noOfChildren = list.getNumberChildren();
        ArrayList<String> values = new ArrayList<String>(noOfChildren);
        for (int index = 0; index < noOfChildren; ++index) {
            SQLLiteral literal = (SQLLiteral)list.getChild(index);
            values.add(literal.getValue().getString());
        }
        String fieldName = column.getName();
        if (fieldName.startsWith("Import")) {
            for (String fieldVal : values) {
                SAPRFCInvocation inv = new SAPRFCInvocation(this.tableName);
                String fieldValue = this.removeApostrophe(fieldVal);
                inv.addImportParam(fieldName, fieldValue);
                this.filters.add(inv);
            }
        } else {
            SAPRFCInvocation inv = new SAPRFCInvocation(this.tableName);
            for (String fieldVal : values) {
                String colvalueStr = this.removeApostrophe(fieldVal);
                inv.addRowFilter(fieldName, colvalueStr);
            }
            this.filters.add(inv);
        }
    }

    @Override
    public void handle(SQLComparison compExpr) {
        if (logger.isDebug()) {
            logger.debug("SQLComparison " + compExpr);
        }
        String operator = this.getOperator(compExpr.getSubType());
        SQLColumn col = (SQLColumn)compExpr.getChild(0);
        SQLLiteral lit = (SQLLiteral)compExpr.getChild(1);
        String fieldname = col.getName();
        String fieldvalue = lit.getValue().getString();
        if (operator.equals("=")) {
            SAPRFCInvocation inv = new SAPRFCInvocation(this.tableName);
            if (fieldname != null) {
                String colvalueStr = this.removeApostrophe(fieldvalue);
                if (fieldname.startsWith("Import")) {
                    inv.addImportParam(fieldname, colvalueStr);
                } else {
                    inv.addRowFilter(fieldname, colvalueStr);
                }
            }
            this.filters.add(inv);
        }
    }

    @Override
    public void handle(SQLBetween betExpr) {
        throw new ERPException(XQEMessageKeys.ERP_OperatorNotSupported, "BETWEEN", TYPE);
    }

    public List<SAPRFCInvocation> getFilters() {
        return this.filters;
    }
}

