/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp.sap;

import com.cognos.xqe.ast.sql.SQLBetween;
import com.cognos.xqe.ast.sql.SQLColumn;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLIn;
import com.cognos.xqe.ast.sql.SQLIsNull;
import com.cognos.xqe.ast.sql.SQLLike;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.data.providers.relational.erp.sap.SAPWhereClauseHandler;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPOptionBuilder;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.metadata.IMetadata;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class SAPTableWhereClauseHandler
extends SAPWhereClauseHandler {
    private final SAPOptionBuilder optionBuilder = new SAPOptionBuilder();
    private Stack<Boolean> currExpressionType = new Stack();

    public SAPTableWhereClauseHandler(String tabName, List<IMetadata> querySubjectList) {
        super(tabName, querySubjectList);
    }

    @Override
    public void handle(SQLLogical logicalExpr) {
        if (logicalExpr.getNumberChildren() == 1) {
            this.currExpressionType.push(Boolean.TRUE);
            this.handle((SQLQueryNode)logicalExpr.getChild(0));
            this.currExpressionType.pop();
        } else {
            String operator = this.getOperator(logicalExpr.getSubType());
            this.currExpressionType.push(Boolean.FALSE);
            this.optionBuilder.buildOption("(");
            this.handle((SQLQueryNode)logicalExpr.getChild(0));
            this.currExpressionType.pop();
            this.optionBuilder.buildOption(" ");
            this.optionBuilder.buildOption(operator);
            this.optionBuilder.buildOption(" ");
            this.currExpressionType.push(Boolean.FALSE);
            this.handle((SQLQueryNode)logicalExpr.getChild(1));
            this.currExpressionType.pop();
            this.optionBuilder.buildOption(")");
        }
    }

    private boolean isNotExpression() {
        if (this.currExpressionType.isEmpty()) {
            return false;
        }
        return this.currExpressionType.peek();
    }

    @Override
    public void handle(SQLLike likeExpr) {
        SQLColumn field = (SQLColumn)likeExpr.getChild(0);
        SQLLiteral fieldVal = (SQLLiteral)likeExpr.getChild(1);
        this.optionBuilder.buildOption(field.getName());
        this.optionBuilder.buildOption(" ");
        this.setSign("LIKE");
        this.optionBuilder.buildOption(" ");
        this.optionBuilder.buildOption(this.getQuotedString(fieldVal.getValue().getString()));
    }

    @Override
    public void handle(SQLIsNull isnullExpr) {
        String fieldName = isnullExpr.getChild(0).getPropertyValue("name").toString();
        this.optionBuilder.buildOption(fieldName);
        this.optionBuilder.buildOption(" ");
        this.setSign("=");
        this.optionBuilder.buildOption("''");
    }

    private void setSign(String sign) {
        if (this.isNotExpression()) {
            this.optionBuilder.buildOption("NOT");
            this.optionBuilder.buildOption(" ");
        }
        this.optionBuilder.buildOption(sign);
        this.optionBuilder.buildOption(" ");
    }

    @Override
    public void handle(SQLIn inExpr) {
        SQLColumn column = (SQLColumn)inExpr.getChild(0);
        SQLValueList list = (SQLValueList)inExpr.getChild(1);
        int noOfChildren = list.getNumberChildren();
        ArrayList<String> values = new ArrayList<String>(noOfChildren);
        for (int index = 0; index < noOfChildren; ++index) {
            SQLLiteral literal = (SQLLiteral)list.getChild(index);
            values.add(this.getQuotedString(literal.getValue().getString()));
        }
        this.optionBuilder.buildOption(" ");
        this.optionBuilder.buildOption(column.getName());
        this.optionBuilder.buildOption(" ");
        this.setSign("IN");
        this.optionBuilder.buildInClauseValues(values);
    }

    @Override
    public void handle(SQLComparison compExpr) {
        String operator = this.getOperator(compExpr.getSubType());
        SQLColumn col = (SQLColumn)compExpr.getChild(0);
        SQLLiteral lit = (SQLLiteral)compExpr.getChild(1);
        String fieldname = col.getName();
        String fieldvalue = lit.getValue().getString();
        if (operator.equals("=") || operator.equals("<=") || operator.equals("<") || operator.equals(">") || operator.equals(">=") || operator.equals("<>")) {
            if (this.isDecimalField(this.tableName, fieldname)) {
                IDataType dataType = this.getDataType(this.tableName, fieldname);
                int scale = dataType.getScale();
                fieldvalue = this.formatDecimalValue(fieldvalue, scale);
            }
            fieldvalue = this.getQuotedString(fieldvalue);
            this.optionBuilder.buildOption(fieldname);
            this.optionBuilder.buildOption(" ");
            this.optionBuilder.buildOption(operator);
            this.optionBuilder.buildOption(" ");
            this.optionBuilder.buildOption(fieldvalue);
        }
    }

    private String formatDecimalValue(String fieldvalue, int scale) {
        String tempValue = this.removeApostrophe(fieldvalue);
        int idx = tempValue.indexOf(46);
        int fractionlen = 0;
        if (idx > -1) {
            fractionlen = fieldvalue.substring(idx + 1).length();
        }
        if (fractionlen > 0 && fractionlen < scale) {
            StringBuilder sb = new StringBuilder();
            sb.append(tempValue);
            for (int i = fractionlen; i < scale; ++i) {
                sb.append('0');
            }
            fieldvalue = sb.toString();
        }
        return fieldvalue;
    }

    @Override
    public void handle(SQLBetween betExpr) {
        SQLColumn field = (SQLColumn)betExpr.getChild(0);
        SQLLiteral fieldValLowerLimit = (SQLLiteral)betExpr.getChild(1);
        SQLLiteral fieldValUpperLimit = (SQLLiteral)betExpr.getChild(2);
        String fieldname = field.getName();
        String fieldvalueLowerLimit = fieldValLowerLimit.getValue().getString();
        String fieldvalueUpperLimit = fieldValUpperLimit.getValue().getString();
        if (this.isDecimalField(this.tableName, fieldname)) {
            IDataType dataType = this.getDataType(this.tableName, fieldname);
            int scale = dataType.getScale();
            fieldvalueLowerLimit = this.formatDecimalValue(fieldvalueLowerLimit, scale);
            fieldvalueUpperLimit = this.formatDecimalValue(fieldvalueUpperLimit, scale);
        }
        fieldvalueLowerLimit = this.getQuotedString(fieldvalueLowerLimit);
        fieldvalueUpperLimit = this.getQuotedString(fieldvalueUpperLimit);
        if (this.isNotExpression()) {
            this.optionBuilder.buildOption("(");
            this.optionBuilder.buildOption(" ");
            this.optionBuilder.buildOption(field.getName());
            this.optionBuilder.buildOption(" ");
            this.optionBuilder.buildOption("<");
            this.optionBuilder.buildOption(" ");
            this.optionBuilder.buildOption(fieldvalueLowerLimit);
            this.optionBuilder.buildOption(" ");
            this.optionBuilder.buildOption("OR");
            this.optionBuilder.buildOption(" ");
            this.optionBuilder.buildOption(field.getName());
            this.optionBuilder.buildOption(" ");
            this.optionBuilder.buildOption(">");
            this.optionBuilder.buildOption(" ");
            this.optionBuilder.buildOption(fieldvalueUpperLimit);
            this.optionBuilder.buildOption(" ");
            this.optionBuilder.buildOption(")");
        } else {
            this.optionBuilder.buildOption("(");
            this.optionBuilder.buildOption(" ");
            this.optionBuilder.buildOption(field.getName());
            this.optionBuilder.buildOption(" ");
            this.optionBuilder.buildOption(">=");
            this.optionBuilder.buildOption(" ");
            this.optionBuilder.buildOption(fieldvalueLowerLimit);
            this.optionBuilder.buildOption(" ");
            this.optionBuilder.buildOption("AND");
            this.optionBuilder.buildOption(" ");
            this.optionBuilder.buildOption(field.getName());
            this.optionBuilder.buildOption(" ");
            this.optionBuilder.buildOption("<=");
            this.optionBuilder.buildOption(" ");
            this.optionBuilder.buildOption(fieldvalueUpperLimit);
            this.optionBuilder.buildOption(" ");
            this.optionBuilder.buildOption(")");
        }
    }

    public List<String> getFilters() {
        return this.optionBuilder.getOptions();
    }
}

