/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp.sap.client;

import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPConstants;
import java.util.HashMap;
import java.util.Map;

public class SAPABAPQueryInfo
implements SAPConstants {
    private final String queryName;
    private final String usrGroup;
    private final String queryText;
    private final String varient;
    private final String varientDesc;
    private final String queryArea;

    public SAPABAPQueryInfo(String queryName, String usrGroup, String queryText, String varient, String varientDesc, String queryArea) {
        this.queryName = queryName;
        this.usrGroup = usrGroup;
        this.queryText = queryText;
        this.varient = varient;
        this.varientDesc = varientDesc;
        this.queryArea = queryArea;
    }

    public Map<String, String> getAttributes() {
        HashMap<String, String> attr = new HashMap<String, String>();
        attr.put("sap-query-usergroup", this.usrGroup);
        attr.put("Query Text", this.queryText);
        attr.put("sap-query-variant", this.varient);
        attr.put("Varient Description", this.varientDesc);
        attr.put("sap-query-name", this.queryName);
        attr.put("sap-query-area", this.queryArea);
        return attr;
    }

    public String getDisplayName() {
        String name;
        StringBuilder sb = new StringBuilder();
        if (this.queryText != null && this.queryText.trim().length() > 0) {
            sb.append(this.queryText);
        }
        if (this.varient != null && this.varient.trim().length() > 0) {
            sb.append(",");
            sb.append(" ");
            sb.append(this.varient);
        }
        if ((name = sb.toString().trim()).length() == 0) {
            sb.append(this.usrGroup);
            sb.append(",");
            sb.append(" ");
            sb.append(this.queryName);
        }
        return sb.toString();
    }

    public String getAnnotation() {
        StringBuilder sb = new StringBuilder();
        sb.append("SAP User Group");
        sb.append(":");
        sb.append(this.usrGroup);
        sb.append(LINE_FEED);
        sb.append("SAP Query Name");
        sb.append(":");
        sb.append(this.queryName);
        sb.append(LINE_FEED);
        if (this.queryText != null && this.queryText.length() > 0) {
            sb.append("Query Text");
            sb.append(":");
            sb.append(this.queryText);
            sb.append(LINE_FEED);
        }
        if (this.varient != null && this.varient.length() > 0) {
            sb.append("Varient");
            sb.append(":");
            sb.append(this.varient);
            sb.append(LINE_FEED);
        }
        if (this.varientDesc != null && this.varientDesc.length() > 0) {
            sb.append("Varient Description");
            sb.append(":");
            sb.append(this.varientDesc);
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" queryName ");
        sb.append(this.queryName);
        sb.append(" usrGroup ");
        sb.append(this.usrGroup);
        sb.append(" queryText ");
        sb.append(this.queryText);
        sb.append(" varient ");
        sb.append(this.varient);
        sb.append(" varientDesc ");
        sb.append(this.varientDesc);
        sb.append(" queryArea ");
        sb.append(this.queryArea);
        return sb.toString();
    }
}

