/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp.sap.client;

import com.cognos.xqe.data.providers.relational.erp.ERPException;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPABAPQueryTable;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPAdvancedProperties;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPBORWrapper;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPConnectionInfo;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPConstants;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPDestinationManager;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPFieldMetadata;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPJCODestinationProvider;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPLogger;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPLoggerFactory;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPQueryTable;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPRFCInvocation;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPSelectionField;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPTableQueryInvocation;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPUtil;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.sap.conn.jco.JCoAttributes;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoField;
import com.sap.conn.jco.JCoFieldIterator;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoFunctionTemplate;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoRepository;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;

public final class SAPClient
implements SAPConstants {
    private static final SAPLogger logger = SAPLoggerFactory.getLogger(SAPClient.class);
    private static ExecutorService executorService;
    private final String isoLanguage;
    private final String serverCharSet;
    private final String dateFormat;
    private volatile SAPBORWrapper borWrapper;
    private final SAPAdvancedProperties advProps;
    private final SAPConnectionInfo connInfo;
    private int tableQueryBatchSize = 300000;
    private int tableRowCount = 50000;
    private JCoDestination _destination;
    private JCoRepository _repository;
    private static Map<String, String> usersDefaultDatesMap;

    public static void initialize(int maxNoOfThreads) {
        if (maxNoOfThreads <= 0) {
            maxNoOfThreads = 10;
        }
        executorService = Executors.newFixedThreadPool(maxNoOfThreads);
    }

    public SAPClient(SAPConnectionInfo connInfo, SAPAdvancedProperties advProps) {
        this.advProps = advProps;
        this.connInfo = connInfo;
        try {
            SAPJCODestinationProvider destProvder = SAPJCODestinationProvider.getInstance();
            String destname = destProvder.addDestinationProperties(connInfo);
            this._destination = destProvder.getDestination(destname);
            this._repository = this._destination.getRepository();
        }
        catch (ERPException e) {
            logger.error("Error in creating the destination", (Throwable)((Object)e));
            throw new ERPException(XQEMessageKeys.ERP_ConnectionError, (Throwable)((Object)e));
        }
        catch (JCoException e) {
            logger.error("Error in creating the destination", e);
            throw new ERPException(XQEMessageKeys.ERP_ConnectionError, e);
        }
        try {
            String rowCountStr;
            JCoAttributes attr = this._destination.getAttributes();
            String lang = connInfo.getLanguage();
            this.isoLanguage = lang != null ? lang : attr.getISOLanguage();
            String pcharSet = attr.getPartnerCharset().toLowerCase();
            this.serverCharSet = pcharSet.indexOf("unicode") >= 0 || pcharSet.indexOf("utf") >= 0 ? null : attr.getPartnerCharset();
            String user = connInfo.getUser();
            if (usersDefaultDatesMap.containsKey(user)) {
                this.dateFormat = usersDefaultDatesMap.get(user);
            } else {
                this.dateFormat = this.getUserDefaultDateFormat();
                usersDefaultDatesMap.put(user, this.dateFormat);
            }
            String batch = advProps.getTableQueryBatchSize();
            if (batch != null && !batch.equals("")) {
                try {
                    this.tableQueryBatchSize = Integer.parseInt(advProps.getTableQueryBatchSize());
                }
                catch (NumberFormatException e) {
                    logger.error("Error in parsing table query batch size " + this.tableQueryBatchSize);
                }
            }
            if ((rowCountStr = advProps.getRowCount()) != null && !rowCountStr.equals("")) {
                try {
                    this.tableRowCount = Integer.parseInt(advProps.getRowCount());
                }
                catch (NumberFormatException e) {
                    logger.error("Error in parsing table table row count " + this.tableRowCount);
                }
            }
            if (logger.isDebug()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Partner release ");
                sb.append(attr.getPartnerRelease());
                sb.append(", Kernal release ");
                sb.append(attr.getKernelRelease());
                sb.append(", Partner character set ");
                sb.append(attr.getPartnerCharset());
                sb.append(", Partner encoding ");
                sb.append(attr.getPartnerEncoding());
                sb.append(", Partner byets/char ");
                sb.append(attr.getPartnerBytesPerChar());
                sb.append(", Own byets/char ");
                sb.append(attr.getOwnBytesPerChar());
                sb.append(", Own encoding ");
                sb.append(attr.getOwnEncoding());
                sb.append(", Own charset ");
                sb.append(attr.getOwnCharset());
                sb.append(", Adapter advanced configuration properties");
                sb.append(", Table read function ");
                sb.append(advProps.getReadTableFunctionName());
                sb.append(", Parse decimal enabled ");
                sb.append(advProps.isParseDecimalValues());
                sb.append(", Table row length ");
                sb.append(advProps.getTableReadFunDataFieldMaxLength());
                sb.append(", Table query batch size ");
                sb.append(advProps.getTableQueryBatchSize());
                sb.append(", Table row count ");
                sb.append(advProps.getRowCount());
                sb.append(", ABAP DB Access Limit ");
                sb.append(advProps.getAbapQueryDbAccesses());
                sb.append(", TableQueryBatchSize: ");
                sb.append(this.tableQueryBatchSize);
                logger.debug(sb.toString());
            }
        }
        catch (JCoException e1) {
            throw new ERPException(e1);
        }
    }

    public void shutDown() {
        SAPDestinationManager.unregisterDestinationProvider();
    }

    protected JCoParameterList getData(String[] fields, String[] options, Map<String, String> importparams, boolean isRFCFunctionGroup) {
        JCoFunctionTemplate ftmpl = null;
        String funTemplName = null;
        funTemplName = isRFCFunctionGroup ? "RFC_FUNCTION_SEARCH" : this.advProps.getReadTableFunctionName();
        ftmpl = this.getFunctionTemplate(funTemplName);
        JCoFunction func = ftmpl.getFunction();
        JCoParameterList imports = func.getImportParameterList();
        if (importparams != null) {
            for (Map.Entry<String, String> entrySet : importparams.entrySet()) {
                String paramName = entrySet.getKey();
                String paramvalue = entrySet.getValue();
                imports.setValue(paramName, paramvalue);
            }
        }
        JCoParameterList parameterList = func.getTableParameterList();
        if (fields != null) {
            JCoTable fieldsTable = parameterList.getTable("FIELDS");
            for (int i = 0; i < fields.length; ++i) {
                fieldsTable.appendRow();
                fieldsTable.setValue("FIELDNAME", fields[i]);
            }
        }
        if (options != null) {
            JCoTable optionTable = parameterList.getTable("OPTIONS");
            int nOptionsLength = options.length;
            if (nOptionsLength >= 1 && options[0].startsWith("(") && options[nOptionsLength - 1].endsWith(")")) {
                options[0] = options[0].substring(1, options[0].length());
                options[nOptionsLength - 1] = options[nOptionsLength - 1].substring(0, options[nOptionsLength - 1].length() - 1);
            }
            for (int i = 0; i < options.length; ++i) {
                optionTable.appendRow();
                optionTable.setValue("TEXT", options[i]);
            }
        }
        if (logger.isDebug()) {
            StringBuilder sb = new StringBuilder();
            sb.append("In get data Fields: ");
            if (fields != null) {
                String[] stringArray = fields;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String field = stringArray[i];
                    sb.append(field);
                    sb.append(",");
                    sb.append(" ");
                }
            }
            sb.append(" Options: ");
            if (options != null) {
                for (String s : options) {
                    sb.append(s);
                    sb.append(",");
                    sb.append(" ");
                }
            }
            sb.append(" Import Parameters: ");
            sb.append(importparams);
            sb.append(" Function template name ");
            sb.append(funTemplName);
            logger.debug(sb.toString());
        }
        this.executeRemoteFunction(func);
        return parameterList;
    }

    public void executeRemoteFunction(JCoFunction function) {
        try {
            if (logger.isDebug()) {
                logger.debug("JCO_REQUEST_STARTED");
            }
            function.execute(this._destination);
            if (logger.isDebug()) {
                logger.debug("JCO_REQUEST_COMPLETED");
            }
        }
        catch (Exception e) {
            logger.error("JCO_REQUEST_FAILED", e);
            throw new ERPException(XQEMessageKeys.ERP_RFCInvocationError, e);
        }
    }

    public SAPQueryTable executeTableQuery(String tablename, List<SAPFieldMetadata> fields, List<String> options) {
        return new SAPTableQueryInvocation(tablename, fields, options, this);
    }

    protected JCoParameterList getTableData(String tablename, List<String> columns, List<String> optiionslist, int rowCount, int rowSkips) {
        if (logger.isDebug()) {
            logger.debug("Executing table query for table " + tablename);
        }
        Map<String, String> importparams = SAPUtil.getImporParams(tablename, new Integer(rowCount).toString(), new Integer(rowSkips).toString());
        String[] options = null;
        if (optiionslist != null) {
            options = optiionslist.toArray(new String[optiionslist.size()]);
        }
        String[] fields = new String[columns.size()];
        int index = 0;
        Iterator<String> iterator = columns.iterator();
        while (iterator.hasNext()) {
            String col;
            fields[index] = col = iterator.next();
            ++index;
        }
        return this.getData(fields, options, importparams, false);
    }

    public SAPABAPQueryTable executeABAPQuery(String queryArea, String userGrp, String queryName, String varient, List<SAPSelectionField> selFields) {
        if (logger.isDebug()) {
            StringBuilder sb = new StringBuilder();
            sb.append("In executeABAPQuery() Query area: ");
            sb.append(queryArea);
            sb.append(", User group: ");
            sb.append(userGrp);
            sb.append(", Query name: ");
            sb.append(queryName);
            sb.append(", Varient: ");
            sb.append(varient);
            sb.append(", Selection Fields:");
            if (selFields != null) {
                for (SAPSelectionField sfield : selFields) {
                    sb.append(sfield.toString());
                    sb.append(",");
                }
            }
            logger.debug(sb.toString());
        }
        JCoFunctionTemplate queryTempl = this.getFunctionTemplate(SAPConstants.FunctTempl.SAP_ABAP_QUERY_FUN_TEMPL);
        JCoFunction function = queryTempl.getFunction();
        JCoParameterList iparams = function.getImportParameterList();
        JCoParameterList tparams = function.getTableParameterList();
        JCoTable selparams = tparams.getTable("SELECTION_TABLE");
        for (SAPSelectionField sfield : selFields) {
            selparams.appendRow();
            selparams.setValue("SELNAME", sfield.getSelectName());
            selparams.setValue("SIGN", sfield.getSign());
            selparams.setValue("OPTION", sfield.getOption());
            selparams.setValue("LOW", sfield.getLow());
            selparams.setValue("HIGH", sfield.getHigh());
        }
        char workplace = SAPUtil.getWorkPlace(queryArea);
        iparams.setValue("WORKSPACE", workplace);
        iparams.setValue("USERGROUP", userGrp);
        iparams.setValue("QUERY", queryName);
        iparams.setValue("VARIANT", varient);
        String dbaccess = this.getABAPQueryDBAccessLimit();
        iparams.setValue("DBACC", dbaccess);
        iparams.setValue("SKIP_SELSCREEN", "X");
        iparams.setValue("DATA_TO_MEMORY", "X");
        iparams.setValue("EXTERNAL_PRESENTATION", "X");
        try {
            function.execute(this._destination);
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message.indexOf("NO_DATA_SELECTED") < 0 && message.indexOf("NO_QUERY") >= 0) {
                throw new ERPException(XQEMessageKeys.ERP_QueryNotExistError, e, queryName);
            }
            logger.debug(message, e);
        }
        JCoParameterList tableParams = function.getTableParameterList();
        SAPABAPQueryTable querytable = new SAPABAPQueryTable(tableParams, this);
        return querytable;
    }

    private String getUserDefaultDateFormat() {
        String dtFormat = null;
        JCoFunction sapSysParameters = this.getFunctionTemplate("RFC_GET_SAP_SYSTEM_PARAMETERS").getFunction();
        if (logger.isDebug()) {
            logger.debug("Fetching user default date format details.");
        }
        this.executeRemoteFunction(sapSysParameters);
        JCoParameterList expparams = sapSysParameters.getExportParameterList();
        dtFormat = expparams.getString("DATE_FORMAT");
        if (logger.isDebug()) {
            logger.debug("Default date format " + dtFormat);
        }
        return dtFormat;
    }

    protected String getServerCharSet() {
        return this.serverCharSet;
    }

    protected String getIsoLanguage() {
        return this.isoLanguage;
    }

    protected JCoFunctionTemplate getFunctionTemplate(String funTemplName) {
        JCoFunctionTemplate funTemplate = null;
        try {
            funTemplate = this._repository.getFunctionTemplate(funTemplName);
        }
        catch (JCoException e) {
            logger.error(" Function Template Error", e);
            throw new ERPException(XQEMessageKeys.ERP_FunctionTemplateError, e, funTemplName);
        }
        return funTemplate;
    }

    protected JCoFunctionTemplate getFunctionTemplate(SAPConstants.FunctTempl type) {
        String funTempName = "";
        switch (type) {
            case SAP_ABAP_FUN_AREA_INFO_TMPL: {
                funTempName = "RSAQ_REMOTE_FUNCAREA_CATALOG";
                break;
            }
            case SAP_ABAP_QUERY_FUN_TEMPL: {
                funTempName = "RSAQ_REMOTE_QUERY_CALL";
                break;
            }
            case SAP_ABAP_QUERY_SEL_FIELDS_TEMPL: {
                funTempName = "RSAQ_REMOTE_QUERY_FIELDLIST";
                break;
            }
            case ABAP_QUERY_FIELDS_FUN_TEMPL: {
                funTempName = "RSAQ_REMOTE_FUNCAREA_FIELDLIST";
                break;
            }
            case ABAP_QUERY_GEN_FUN_TEMPL: {
                funTempName = "RSAQ_REMOTE_QUERY_GENERATION";
                break;
            }
            case SAP_ABAP_QUERYLIST_FUN_TMPL: {
                funTempName = "RSAQ_REMOTE_QUERY_CALL_CATALOG";
                break;
            }
            case SAP_ABAP_QUERY_DELETE_FUN: {
                funTempName = "RSAQ_REMOTE_QUERY_DELETE";
                break;
            }
            case SAP_BOR_FUN_TEMP: {
                funTempName = "RPY_BOR_TREE_INIT";
                break;
            }
            case SAP_BAPI_FUN_TMPL: {
                funTempName = "SWO_QUERY_API_METHODS";
            }
        }
        return this.getFunctionTemplate(funTempName);
    }

    protected String getABAPQueryDBAccessLimit() {
        return this.advProps.getAbapQueryDbAccesses();
    }

    protected SAPBORWrapper getBorWrapper() {
        return this.borWrapper;
    }

    protected void setBorWrapper(SAPBORWrapper borWrapper) {
        this.borWrapper = borWrapper;
    }

    public SAPRFCInvocation executeRFCQuery(SAPRFCInvocation rfcInv) {
        if (logger.isDebug()) {
            logger.debug("executeRFCQuery " + rfcInv.toString());
        }
        JCoFunctionTemplate queryTempl = this.getFunctionTemplate(rfcInv.getRfc());
        JCoFunction function = queryTempl.getFunction();
        Map<String, String> importParamsFilters = rfcInv.getImportParams();
        JCoParameterList importParameterList = function.getImportParameterList();
        block0: for (Map.Entry<String, String> entry : importParamsFilters.entrySet()) {
            String fieldName = entry.getKey();
            String fieldValue = entry.getValue();
            String sapFieldName = SAPUtil.extractFieldName(fieldName);
            int i = sapFieldName.indexOf(32);
            if (i > -1) {
                String structname = sapFieldName.substring(0, i);
                String colname = sapFieldName.substring(i + 1);
                JCoStructure str = importParameterList.getStructure(structname);
                JCoFieldIterator fieldIterator = str.getFieldIterator();
                while (fieldIterator.hasNextField()) {
                    JCoField field = fieldIterator.nextField();
                    if (!field.getName().equals(colname)) continue;
                    field.setValue(fieldValue);
                    continue block0;
                }
                continue;
            }
            importParameterList.setValue(sapFieldName, fieldValue);
        }
        JCoParameterList tableParameterList = function.getTableParameterList();
        Map<String, List<SAPRFCInvocation.RFCTableRowFilter>> tableParamfilters = rfcInv.getTableParams();
        for (Map.Entry<String, List<SAPRFCInvocation.RFCTableRowFilter>> entry : tableParamfilters.entrySet()) {
            String tablename = entry.getKey();
            int tableNameLen = tablename.length();
            JCoTable table = tableParameterList.getTable(tablename);
            List<SAPRFCInvocation.RFCTableRowFilter> rows = entry.getValue();
            for (SAPRFCInvocation.RFCTableRowFilter row : rows) {
                Map<String, String> columFilterMap = row.getColumFilters();
                table.appendRow();
                for (Map.Entry<String, String> filter : columFilterMap.entrySet()) {
                    String key = filter.getKey();
                    String columnname = key.substring(tableNameLen + 1);
                    String colvalue = filter.getValue();
                    table.setValue(columnname, colvalue);
                }
            }
        }
        this.executeRemoteFunction(function);
        rfcInv.setData(function);
        return rfcInv;
    }

    protected ExecutorService getExecutorService() {
        return executorService;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    protected int getTableRowCount() {
        return this.tableRowCount;
    }

    protected int getTableQueryBatchSize() {
        return this.tableQueryBatchSize;
    }

    protected void updateJunitProp(int a, int b) {
        this.tableRowCount = a;
        this.tableQueryBatchSize = b;
    }

    public void releaseResources() {
        SAPJCODestinationProvider.getInstance().removeDestinationProperties(this.connInfo);
        ThreadPoolExecutor threadPool = (ThreadPoolExecutor)this.getExecutorService();
        threadPool.shutdown();
    }

    public Map<String, String> getDateTimeDefaultValuesMap() {
        return this.advProps.getSapDefaultDateTimeValuesMap();
    }

    public boolean isParseDecimalValues() {
        return this.advProps.isParseDecimalValues();
    }

    public int getTableReadFunDataFieldMaxLength() {
        return this.advProps.getTableReadFunDataFieldMaxLength();
    }

    static {
        usersDefaultDatesMap = new ConcurrentHashMap<String, String>();
    }
}

